/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.util.Debug;
import org.w3c.dom.Element;
import tyrex.resource.jdbc.xa.EnabledDataSource;

public class TyrexConnectionFactory {
    protected static Map dsCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, Element inlineJdbcElement) throws SQLException, GenericEntityException {
        boolean usingTyrex = true;
        if (usingTyrex) {
            EnabledDataSource ds = (EnabledDataSource)dsCache.get(helperName);
            if (ds != null) {
                return TransactionUtil.enlistConnection(ds.getXAConnection());
            }
            Class<TyrexConnectionFactory> clazz = TyrexConnectionFactory.class;
            synchronized (TyrexConnectionFactory.class) {
                ds = (EnabledDataSource)dsCache.get(helperName);
                if (ds != null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return TransactionUtil.enlistConnection(ds.getXAConnection());
                }
                ds = new EnabledDataSource();
                ds.setDriverClassName(inlineJdbcElement.getAttribute("jdbc-driver"));
                ds.setDriverName(inlineJdbcElement.getAttribute("jdbc-uri"));
                ds.setUser(inlineJdbcElement.getAttribute("jdbc-username"));
                ds.setPassword(inlineJdbcElement.getAttribute("jdbc-password"));
                ds.setDescription(helperName);
                String transIso = inlineJdbcElement.getAttribute("isolation-level");
                if (transIso != null && transIso.length() > 0) {
                    ds.setIsolationLevel(transIso);
                }
                ds.setLogWriter(Debug.getPrintWriter());
                dsCache.put(helperName, ds);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return TransactionUtil.enlistConnection(ds.getXAConnection());
            }
        }
        return null;
    }
}

