/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.util.Debug;
import org.w3c.dom.Element;

public class DBCPConnectionFactory {
    protected static Map dsCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, Element dbcpJdbcElement) throws SQLException, GenericEntityException {
        DataSource dataSource = (DataSource)dsCache.get(helperName);
        if (dataSource != null) {
            return dataSource.getConnection();
        }
        try {
            Class<DBCPConnectionFactory> clazz = DBCPConnectionFactory.class;
            synchronized (DBCPConnectionFactory.class) {
                dataSource = (DataSource)dsCache.get(helperName);
                if (dataSource != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return dataSource.getConnection();
                }
                GenericObjectPool connectionPool = new GenericObjectPool(null);
                String connectURI = dbcpJdbcElement.getAttribute("jdbc-uri");
                String username = dbcpJdbcElement.getAttribute("jdbc-username");
                String password = dbcpJdbcElement.getAttribute("jdbc-password");
                String driverClassName = dbcpJdbcElement.getAttribute("jdbc-driver");
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                loader.loadClass(driverClassName);
                DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, password);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
                dataSource = new PoolingDataSource((ObjectPool)connectionPool);
                dataSource.setLogWriter(Debug.getPrintWriter());
                dsCache.put(helperName, dataSource);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return dataSource.getConnection();
            }
        }
        catch (Exception e) {
            String errorMsg = "Error getting datasource via DBCP.";
            Debug.logError((Throwable)e, (String)errorMsg);
            return null;
        }
    }
}

