/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.th.ThaiWordFilter;

public class ThaiAnalyzer
extends Analyzer {
    public ThaiAnalyzer() {
        this.setOverridesTokenStreamMethod(ThaiAnalyzer.class);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object ts = new StandardTokenizer(reader);
        ts = new StandardFilter((TokenStream)ts);
        ts = new ThaiWordFilter((TokenStream)ts);
        ts = new StopFilter((TokenStream)ts, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        return ts;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new ThaiWordFilter(streams.result);
            streams.result = new StopFilter(streams.result, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
            streams.result.reset();
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

