/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.job;

import java.util.Iterator;
import java.util.LinkedList;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.job.Job;
import org.ofbiz.core.service.job.JobInvoker;
import org.ofbiz.core.service.job.JobManager;
import org.ofbiz.core.util.Debug;

public class JobPoller
implements Runnable {
    public static final String module = JobPoller.class.getName();
    public static final int MIN_THREADS = 1;
    public static final int MAX_THREADS = 15;
    public static final int MAX_JOBS = 3;
    public static final int POLL_WAIT = 20000;
    protected boolean isRunning = false;
    protected Thread thread = null;
    protected LinkedList pool = null;
    protected LinkedList run = null;
    protected JobManager jm = null;

    public JobPoller(JobManager jm) {
        this.jm = jm;
        this.run = new LinkedList();
        this.pool = this.createThreadPool();
        if (this.pollEnabled()) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.setDaemon(false);
            this.isRunning = true;
            this.thread.start();
        }
    }

    protected JobPoller() {
    }

    public synchronized void run() {
        if (Debug.infoOn()) {
            Debug.logInfo((String)("JobPoller: (" + this.thread.getName() + ") Thread Running..."), (String)module);
        }
        while (this.isRunning) {
            try {
                Iterator poll = this.jm.poll();
                while (poll.hasNext()) {
                    Job job = (Job)poll.next();
                    if (!job.isValid()) continue;
                    this.queueNow(job);
                }
                this.wait(this.pollWaitTime());
            }
            catch (InterruptedException e) {
                Debug.logError((Throwable)e, (String)module);
                this.stop();
            }
        }
        if (Debug.infoOn()) {
            Debug.logInfo((String)("JobPoller: (" + this.thread.getName() + ") Thread ending..."), (String)module);
        }
    }

    public JobManager getManager() {
        return this.jm;
    }

    public void stop() {
        this.isRunning = false;
        this.destroyThreadPool();
    }

    private void destroyThreadPool() {
        Debug.logInfo((String)"Destroying thread pool...", (String)module);
        for (JobInvoker ji : this.pool) {
            ji.stop();
        }
        this.pool.clear();
    }

    public synchronized Job next() {
        if (this.run.size() > 0) {
            return (Job)this.run.removeFirst();
        }
        return null;
    }

    public synchronized void queueNow(Job job) {
        this.run.add(job);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("New run queue size: " + this.run.size()), (String)module);
        }
        if (this.run.size() > this.pool.size() && this.pool.size() < this.maxThreads()) {
            int calcSize = this.run.size() / this.jobsPerThread() - this.pool.size();
            int addSize = calcSize > this.maxThreads() ? this.maxThreads() : calcSize;
            for (int i = 0; i < addSize; ++i) {
                JobInvoker iv = new JobInvoker(this, this.invokerWaitTime());
                this.pool.add(iv);
            }
        }
    }

    public synchronized void removeThread(JobInvoker invoker) {
        this.pool.remove(invoker);
        invoker.stop();
        if (this.pool.size() < this.minThreads()) {
            for (int i = 0; i < this.minThreads() - this.pool.size(); ++i) {
                JobInvoker iv = new JobInvoker(this, this.invokerWaitTime());
                this.pool.add(iv);
            }
        }
    }

    private LinkedList createThreadPool() {
        LinkedList<JobInvoker> threadPool = new LinkedList<JobInvoker>();
        while (threadPool.size() < this.minThreads()) {
            JobInvoker iv = new JobInvoker(this, this.invokerWaitTime());
            threadPool.add(iv);
        }
        return threadPool;
    }

    private int maxThreads() {
        int max = 15;
        try {
            max = Integer.parseInt(ServiceConfigUtil.getElementAttr("thread-pool", "max-threads"));
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)("Problems reading values from serviceengine.xml file [" + nfe.toString() + "]. Using defaults."), (String)module);
        }
        return max;
    }

    private int minThreads() {
        int min = 1;
        try {
            min = Integer.parseInt(ServiceConfigUtil.getElementAttr("thread-pool", "min-threads"));
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)("Problems reading values from serviceengine.xml file [" + nfe.toString() + "]. Using defaults."), (String)module);
        }
        return min;
    }

    private int jobsPerThread() {
        int jobs = 3;
        try {
            jobs = Integer.parseInt(ServiceConfigUtil.getElementAttr("thread-pool", "jobs"));
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)("Problems reading values from serviceengine.xml file [" + nfe.toString() + "]. Using defaults."), (String)module);
        }
        return jobs;
    }

    private int invokerWaitTime() {
        int wait = 750;
        try {
            wait = Integer.parseInt(ServiceConfigUtil.getElementAttr("thread-pool", "wait-millis"));
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)("Problems reading values from serviceengine.xml file [" + nfe.toString() + "]. Using defaults."), (String)module);
        }
        return wait;
    }

    private int pollWaitTime() {
        int poll = 20000;
        try {
            poll = Integer.parseInt(ServiceConfigUtil.getElementAttr("thread-pool", "poll-db-millis"));
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)("Problems reading values from serviceengine.xml file [" + nfe.toString() + "]. Using defaults."), (String)module);
        }
        return poll;
    }

    private boolean pollEnabled() {
        String enabled = ServiceConfigUtil.getElementAttr("thread-pool", "poll-enabled");
        if (enabled.equalsIgnoreCase("false")) {
            return false;
        }
        if (this.jm.getDelegator() == null) {
            Debug.logWarning((String)"No delegator referenced; not starting job poller.", (String)module);
            return false;
        }
        return true;
    }
}

