/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.job;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.calendar.RecurrenceInfo;
import org.ofbiz.core.calendar.RecurrenceInfoException;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.serialize.SerializeException;
import org.ofbiz.core.serialize.XmlSerializer;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.job.Job;
import org.ofbiz.core.service.job.JobManagerException;
import org.ofbiz.core.service.job.JobPoller;
import org.ofbiz.core.service.job.PersistedServiceJob;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilDateTime;
import org.ofbiz.core.util.UtilMisc;

public class JobManager {
    public static final String module = JobManager.class.getName();
    protected GenericDelegator delegator;
    protected ServiceDispatcher dispatcher;
    protected JobPoller jp;

    public JobManager(ServiceDispatcher dispatcher, GenericDelegator delegator) {
        this.dispatcher = dispatcher;
        this.delegator = delegator;
        this.jp = new JobPoller(this);
    }

    public void runJob(Job job) throws JobManagerException {
        if (job.isValid()) {
            this.jp.queueNow(job);
        }
    }

    public ServiceDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public GenericDelegator getDelegator() {
        return this.delegator;
    }

    public synchronized Iterator poll() {
        ArrayList<PersistedServiceJob> poll = new ArrayList<PersistedServiceJob>();
        List jobEnt = null;
        List order = UtilMisc.toList((Object)"runTime");
        List expressions = UtilMisc.toList((Object)new EntityExpr("runTime", EntityOperator.LESS_THAN, (Object)UtilDateTime.nowTimestamp()), (Object)new EntityExpr("startDateTime", EntityOperator.EQUALS, null));
        try {
            jobEnt = this.delegator.findByAnd("JobSandbox", expressions, order);
        }
        catch (GenericEntityException ee) {
            Debug.logError((Throwable)ee, (String)"Cannot load jobs from datasource.", (String)module);
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Unknown error.", (String)module);
            e.printStackTrace();
        }
        if (jobEnt != null && jobEnt.size() > 0) {
            for (GenericValue v : jobEnt) {
                String loader = v.getString("loaderName");
                DispatchContext dctx = this.dispatcher.getLocalContext(loader);
                if (dctx == null) {
                    Debug.logWarning((String)("Job (" + v.getString("jobName") + " scheduled to run at " + v.getTimestamp("runTime") + " has an invalid service loader."), (String)module);
                    continue;
                }
                PersistedServiceJob job = new PersistedServiceJob(dctx, v, null);
                poll.add(job);
            }
        }
        return poll.iterator();
    }

    public void schedule(String loader, String serviceName, Map context, long startTime, int frequency, int interval, int count) throws JobManagerException {
        this.schedule(loader, serviceName, context, startTime, frequency, interval, count, 0L);
    }

    public void schedule(String loader, String serviceName, Map context, long startTime, int frequency, int interval, long endTime) throws JobManagerException {
        this.schedule(loader, serviceName, context, startTime, frequency, interval, -1, endTime);
    }

    public void schedule(String loader, String serviceName, Map context, long startTime, int frequency, int interval, int count, long endTime) throws JobManagerException {
        String dataId = null;
        String infoId = null;
        String jobName = new String(new Long(new Date().getTime()).toString());
        if (this.delegator == null) {
            Debug.logWarning((String)"No delegator referenced; cannot schedule job.", (String)module);
            return;
        }
        try {
            dataId = this.delegator.getNextSeqId("RuntimeData").toString();
            GenericValue runtimeData = this.delegator.makeValue("RuntimeData", UtilMisc.toMap((String)"runtimeDataId", (Object)dataId));
            runtimeData.set("runtimeInfo", (Object)XmlSerializer.serialize((Object)context));
            this.delegator.create(runtimeData);
        }
        catch (GenericEntityException ee) {
            throw new JobManagerException(ee.getMessage(), ee);
        }
        catch (SerializeException se) {
            throw new JobManagerException(se.getMessage(), se);
        }
        catch (IOException ioe) {
            throw new JobManagerException(ioe.getMessage(), ioe);
        }
        try {
            RecurrenceInfo info = RecurrenceInfo.makeInfo((GenericDelegator)this.delegator, (long)startTime, (int)frequency, (int)interval, (int)count);
            infoId = info.primaryKey();
        }
        catch (RecurrenceInfoException e) {
            throw new JobManagerException(e.getMessage(), e);
        }
        Map jFields = UtilMisc.toMap((String)"jobName", (Object)jobName, (String)"runTime", (Object)new Timestamp(startTime), (String)"serviceName", (Object)serviceName, (String)"loaderName", (Object)loader, (String)"recurrenceInfoId", (Object)infoId, (String)"runtimeDataId", (Object)dataId);
        GenericValue jobV = null;
        try {
            jobV = this.delegator.makeValue("JobSandbox", jFields);
            this.delegator.create(jobV);
        }
        catch (GenericEntityException e) {
            throw new JobManagerException(e.getMessage(), e);
        }
    }

    public void finalize() {
        if (this.jp != null) {
            this.jp.stop();
            this.jp = null;
            Debug.logInfo((String)"JobManager: Stopped Scheduler Thread.");
        }
    }
}

