/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.job;

import java.util.Date;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.job.Job;
import org.ofbiz.core.service.job.JobPoller;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilDateTime;

public class JobInvoker
implements Runnable {
    public static final String module = JobInvoker.class.getName();
    public static final long THREAD_TTL = 18000000L;
    public static final int WAIT_TIME = 750;
    private JobPoller jp = null;
    private Thread thread = null;
    private Date created = null;
    private int count = 0;
    private int wait = 0;
    private boolean run = false;

    public JobInvoker(JobPoller jp) {
        this(jp, 750);
    }

    public JobInvoker(JobPoller jp, int wait) {
        this.created = new Date();
        this.run = true;
        this.count = 0;
        this.jp = jp;
        this.wait = wait;
        this.thread = new Thread(this);
        this.thread.setDaemon(false);
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("JobInoker: Starting Invoker Thread -- " + this.thread.getName()), (String)module);
        }
        this.thread.start();
    }

    protected JobInvoker() {
    }

    public void stop() {
        this.run = false;
    }

    public void wakeUp() {
        this.notifyAll();
    }

    public int getUsage() {
        return this.count;
    }

    public long getTime() {
        return this.created.getTime();
    }

    public synchronized void run() {
        while (this.run) {
            Job job = this.jp.next();
            if (job == null) {
                try {
                    this.wait(this.wait);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    this.stop();
                }
            } else {
                if (Debug.verboseOn()) {
                    Debug.logVerbose((String)("Invoker: " + this.thread.getName() + " executing job -- " + job.getJobName()), (String)module);
                }
                job.exec();
                if (Debug.verboseOn()) {
                    Debug.logVerbose((String)("Invoker: " + this.thread.getName() + " finished executing job -- " + job.getJobName()), (String)module);
                }
                ++this.count;
                if (Debug.verboseOn()) {
                    Debug.logVerbose((String)("Invoker: " + this.thread.getName() + " (" + this.count + ") total."), (String)module);
                }
            }
            long diff = new Date().getTime() - this.getTime();
            if (this.getTTL() <= 0L || diff <= this.getTTL()) continue;
            this.jp.removeThread(this);
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Invoker: " + this.thread.getName() + " dead -- " + UtilDateTime.nowTimestamp()), (String)module);
        }
    }

    private long getTTL() {
        long ttl = 18000000L;
        try {
            ttl = Long.parseLong(ServiceConfigUtil.getElementAttr("thread-pool", "ttl"));
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)("Problems reading values from serviceengine.xml file [" + nfe.toString() + "]. Using defaults."), (String)module);
        }
        return ttl;
    }
}

