/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.jms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.jms.AbstractJmsListener;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;

public class JmsQueueListener
extends AbstractJmsListener {
    public static final String module = JmsQueueListener.class.getName();
    private QueueConnection con = null;
    private QueueSession session = null;
    private Queue queue = null;
    private String jndiServer;
    private String jndiName;
    private String queueName;
    private String userName;
    private String password;

    public JmsQueueListener(ServiceDispatcher dispatcher, String jndiServer, String jndiName, String queueName, String userName, String password) {
        super(dispatcher);
        this.jndiServer = jndiServer;
        this.jndiName = jndiName;
        this.queueName = queueName;
        this.userName = userName;
        this.password = password;
    }

    public void close() throws GenericServiceException {
        try {
            this.session.close();
            this.con.close();
        }
        catch (JMSException e) {
            throw new GenericServiceException("Cannot close connection(s).", e);
        }
    }

    public synchronized void load() throws GenericServiceException {
        try {
            InitialContext jndi = JNDIContextFactory.getInitialContext((String)this.jndiServer);
            QueueConnectionFactory factory = (QueueConnectionFactory)jndi.lookup(this.jndiName);
            if (factory != null) {
                this.con = factory.createQueueConnection(this.userName, this.password);
                this.con.setExceptionListener((ExceptionListener)this);
                this.session = this.con.createQueueSession(false, 1);
                this.queue = (Queue)jndi.lookup(this.queueName);
                if (this.queue == null) {
                    throw new GenericServiceException("Queue lookup failed.");
                }
            } else {
                throw new GenericServiceException("Factory (broker) lookup failed.");
            }
            QueueReceiver receiver = this.session.createReceiver(this.queue);
            receiver.setMessageListener((MessageListener)this);
            this.con.start();
            this.setConnected(true);
            Debug.logInfo((String)("Listening to queue [" + this.queueName + "]..."), (String)module);
        }
        catch (NamingException ne) {
            throw new GenericServiceException("JNDI lookup problems; listener not running.", ne);
        }
        catch (JMSException je) {
            throw new GenericServiceException("JMS internal error; listener not running.", je);
        }
        catch (GeneralException ge) {
            throw new GenericServiceException("Problems with InitialContext; listener not running.", ge);
        }
    }
}

