/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.group;

import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.group.GroupModel;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class ServiceGroupReader {
    public static final String module = ServiceGroupReader.class.getName();
    public static UtilCache groupsCache = new UtilCache("service.ServiceGroups", 0L, 0L, false);

    public static void readConfig() {
        Element rootElement = null;
        try {
            rootElement = ServiceConfigUtil.getXmlRootElement();
        }
        catch (GenericConfigException e) {
            Debug.logError((Throwable)e, (String)"Error getting Service Engine XML root element", (String)module);
            return;
        }
        List serviceGroupElements = UtilXml.childElementList((Element)rootElement, (String)"service-groups");
        for (Element serviceGroupElement : serviceGroupElements) {
            ResourceHandler handler = new ResourceHandler("serviceengine.xml", serviceGroupElement);
            ServiceGroupReader.addGroupDefinitions(handler);
        }
    }

    public static void addGroupDefinitions(ResourceHandler handler) {
        Element rootElement = null;
        try {
            rootElement = handler.getDocument().getDocumentElement();
        }
        catch (GenericConfigException e) {
            Debug.logError((Throwable)e);
            return;
        }
        List groupList = UtilXml.childElementList((Element)rootElement, (String)"group");
        Iterator groupIt = groupList.iterator();
        int numDefs = 0;
        while (groupIt.hasNext()) {
            Element group = (Element)groupIt.next();
            String groupName = group.getAttribute("name");
            groupsCache.put((Object)groupName, (Object)new GroupModel(group));
            ++numDefs;
        }
        Debug.logImportant((String)("Loaded " + numDefs + " Group definitions from " + handler.getLocation() + " in loader " + handler.getLoaderName()), (String)module);
    }

    public static GroupModel getGroupModel(String serviceName) {
        if (groupsCache.size() == 0L) {
            ServiceGroupReader.readConfig();
        }
        return (GroupModel)groupsCache.get((Object)serviceName);
    }
}

