/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.util.Debug;
import org.w3c.dom.Element;

public class GroupServiceModel {
    public static final String module = GroupServiceModel.class.getName();
    private String serviceName;
    private String serviceMode;
    private boolean resultToContext = false;

    public GroupServiceModel(Element service) {
        this.serviceName = service.getAttribute("name");
        this.serviceMode = service.getAttribute("mode");
        this.resultToContext = service.getAttribute("result-to-context").equalsIgnoreCase("true");
    }

    public GroupServiceModel(String serviceName, String serviceMode) {
        this.serviceName = serviceName;
        this.serviceMode = serviceMode;
    }

    public String getMode() {
        return this.serviceMode;
    }

    public String getName() {
        return this.serviceName;
    }

    public boolean resultToContext() {
        return this.resultToContext;
    }

    public Map invoke(ServiceDispatcher dispatcher, String localName, Map context) throws GenericServiceException {
        DispatchContext dctx = dispatcher.getLocalContext(localName);
        ModelService model = dctx.getModelService(this.getName());
        if (model == null) {
            throw new GenericServiceException("Group defined service (" + this.getName() + ") is not a defined service.");
        }
        Map thisContext = model.makeValid(context, "IN");
        if (this.getMode().equals("async")) {
            List requiredOut = model.getParameterNames("OUT", false);
            if (requiredOut.size() > 0) {
                Debug.logWarning((String)("Grouped service (" + this.getName() + ") requested 'async' invocation; running sync because of required OUT parameters."), (String)module);
                return dispatcher.runSync(localName, model, thisContext);
            }
            dispatcher.runAsync(localName, model, thisContext, false);
            return new HashMap();
        }
        return dispatcher.runSync(localName, model, thisContext);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getName());
        str.append("::");
        str.append(this.getMode());
        str.append("::");
        return str.toString();
    }
}

