/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.group;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.group.GroupServiceModel;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class GroupModel {
    public static final String module = GroupModel.class.getName();
    private String groupName;
    private String sendMode;
    private List services;
    private int lastServiceRan = -1;

    public GroupModel(Element group) {
        this.services = new LinkedList();
        List serviceList = UtilXml.childElementList((Element)group, (String)"service");
        for (Element service : serviceList) {
            this.services.add(new GroupServiceModel(service));
        }
        this.groupName = group.getAttribute("name");
        this.sendMode = group.getAttribute("send-mode");
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Created Service Group Model --> " + this), (String)module);
        }
    }

    public GroupModel(String groupName, String sendMode, List services) {
        this.groupName = groupName;
        this.sendMode = sendMode;
        this.services = services;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getSendMode() {
        return this.sendMode;
    }

    public List getServices() {
        return this.services;
    }

    public Map run(ServiceDispatcher dispatcher, String localName, Map context) throws GenericServiceException {
        if (this.getSendMode().equals("all")) {
            return this.runAll(dispatcher, localName, context);
        }
        if (this.getSendMode().equals("round-robin")) {
            return this.runIndex(dispatcher, localName, context, ++this.lastServiceRan);
        }
        if (this.getSendMode().equals("random")) {
            int randomIndex = (int)(Math.random() * (double)this.services.size());
            return this.runIndex(dispatcher, localName, context, randomIndex);
        }
        if (this.getSendMode().equals("first-available")) {
            return this.runOne(dispatcher, localName, context);
        }
        if (this.getSendMode().equals("none")) {
            return new HashMap();
        }
        throw new GenericServiceException("This mode is not currently supported");
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getGroupName());
        str.append("::");
        str.append(this.getSendMode());
        str.append("::");
        str.append(this.getServices());
        return str.toString();
    }

    private Map runAll(ServiceDispatcher dispatcher, String localName, Map context) throws GenericServiceException {
        HashMap runContext = new HashMap(context);
        HashMap result = new HashMap();
        for (GroupServiceModel model : this.services) {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Using Context: " + runContext), (String)module);
            }
            Map thisResult = model.invoke(dispatcher, localName, runContext);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Result: " + thisResult), (String)module);
            }
            result.putAll(thisResult);
            if (!model.resultToContext()) continue;
            runContext.putAll(thisResult);
            Debug.logVerbose((String)"Added result(s) to context.", (String)module);
        }
        return result;
    }

    private Map runIndex(ServiceDispatcher dispatcher, String localName, Map context, int index) throws GenericServiceException {
        GroupServiceModel model = (GroupServiceModel)this.services.get(index);
        return model.invoke(dispatcher, localName, context);
    }

    private Map runOne(ServiceDispatcher dispatcher, String localName, Map context) throws GenericServiceException {
        Map result = null;
        Iterator i = this.services.iterator();
        while (i.hasNext() && result != null) {
            GroupServiceModel model = (GroupServiceModel)i.next();
            try {
                result = model.invoke(dispatcher, localName, context);
            }
            catch (GenericServiceException e) {
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose((String)("Service: " + model + " failed."), (String)module);
            }
        }
        if (result == null) {
            throw new GenericServiceException("All services failed to run; none availabel.");
        }
        return result;
    }
}

