/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.serialize.XmlSerializer;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.engine.GenericAsyncEngine;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.HttpClient;
import org.ofbiz.core.util.HttpClientException;

public class HttpEngine
extends GenericAsyncEngine {
    public static final String module = HttpEngine.class.getName();

    public HttpEngine(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    public Map runSync(String localName, ModelService modelService, Map context) throws GenericServiceException {
        DispatchContext dctx = this.dispatcher.getLocalContext(localName);
        String xmlContext = null;
        try {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Serializing Context --> " + context), (String)module);
            }
            xmlContext = XmlSerializer.serialize((Object)context);
        }
        catch (Exception e) {
            throw new GenericServiceException("Cannot serialize context.", e);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serviceName", modelService.invoke);
        if (xmlContext != null) {
            parameters.put("serviceContext", xmlContext);
        }
        HttpClient http = new HttpClient(modelService.location, parameters);
        String postResult = null;
        try {
            postResult = http.post();
        }
        catch (HttpClientException e) {
            throw new GenericServiceException("Problems invoking HTTP request", e);
        }
        Map result = null;
        try {
            Object res = XmlSerializer.deserialize((String)postResult, (GenericDelegator)dctx.getDelegator());
            if (!(res instanceof Map)) {
                throw new GenericServiceException("Result not an instance of Map.");
            }
            result = (Map)res;
        }
        catch (Exception e) {
            throw new GenericServiceException("Problems deserializing result.", e);
        }
        return result;
    }

    public void runSyncIgnore(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Map result = this.runSync(localName, modelService, context);
    }

    public static String httpEngine(HttpServletRequest request, HttpServletResponse response) {
        Map result;
        block20: {
            LocalDispatcher dispatcher = (LocalDispatcher)request.getAttribute("dispatcher");
            GenericDelegator delegator = (GenericDelegator)request.getAttribute("delegator");
            String serviceName = request.getParameter("serviceName");
            String serviceMode = request.getParameter("serviceMode");
            String xmlContext = request.getParameter("serviceContext");
            result = new HashMap<String, String>();
            Map context = null;
            if (serviceName == null) {
                result.put("errorMessage", "Cannot have null service name");
            }
            if (serviceMode == null) {
                serviceMode = "SYNC";
            }
            if (!result.containsKey("errorMessage") && xmlContext != null) {
                try {
                    Object o = XmlSerializer.deserialize((String)xmlContext, (GenericDelegator)delegator);
                    if (o instanceof Map) {
                        context = (Map)o;
                    } else {
                        Debug.logError((String)"Context not an instance of Map error", (String)module);
                        result.put("errorMessage", "Context not an instance of Map");
                    }
                }
                catch (Exception e) {
                    Debug.logError((Throwable)e, (String)"Deserialization error", (String)module);
                    result.put("errorMessage", "Error occurred deserializing context: " + e.toString());
                }
            }
            if (!result.containsKey("errorMessage")) {
                try {
                    ModelService model = dispatcher.getDispatchContext().getModelService(serviceName);
                    if (model.export) {
                        if (serviceMode.equals("ASYNC")) {
                            dispatcher.runAsync(serviceName, context);
                        } else {
                            result = dispatcher.runSync(serviceName, context);
                        }
                        break block20;
                    }
                    Debug.logWarning((String)("Attempt to invoke a non-exported service: " + serviceName), (String)module);
                    throw new GenericServiceException("Cannot find requested service.");
                }
                catch (GenericServiceException e) {
                    Debug.logError((Throwable)((Object)e), (String)"Service invocation error", (String)module);
                    result.put("errorMessage", "Service invocation error: " + e.toString());
                }
            }
        }
        StringBuffer errorMessage = new StringBuffer();
        String resultString = null;
        try {
            resultString = XmlSerializer.serialize(result);
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Cannot serialize result", (String)module);
            if (result.containsKey("errorMessage")) {
                errorMessage.append(result.get("errorMessage"));
            }
            errorMessage.append("::");
            errorMessage.append(e);
        }
        try {
            PrintWriter out = response.getWriter();
            response.setContentType("plain/text");
            if (errorMessage.length() > 0) {
                response.setContentLength(errorMessage.length());
                out.write(errorMessage.toString());
            } else {
                response.setContentLength(resultString.length());
                out.write(resultString);
            }
            out.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            Debug.logError((Throwable)e, (String)"Problems w/ getting the servlet writer.", (String)module);
            return "error";
        }
        return null;
    }
}

