/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.engine.GenericEngine;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class GenericEngineFactory {
    protected ServiceDispatcher dispatcher = null;
    protected Map engines = null;

    public GenericEngineFactory(ServiceDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.engines = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GenericEngine getGenericEngine(String engineName) throws GenericServiceException {
        Element rootElement = null;
        try {
            rootElement = ServiceConfigUtil.getXmlRootElement();
        }
        catch (GenericConfigException e) {
            throw new GenericServiceException("Error getting Service Engine XML root element", e);
        }
        Element engineElement = UtilXml.firstChildElement((Element)rootElement, (String)"engine", (String)"name", (String)engineName);
        if (engineElement == null) {
            throw new GenericServiceException("Cannot find an engine definition for the engine name [" + engineName + "] in the serviceengine.xml file");
        }
        String className = engineElement.getAttribute("class");
        GenericEngine engine = (GenericEngine)this.engines.get(engineName);
        if (engine != null) return engine;
        Class<GenericEngineFactory> clazz = GenericEngineFactory.class;
        synchronized (GenericEngineFactory.class) {
            engine = (GenericEngine)this.engines.get(engineName);
            if (engine != null) return engine;
            Class[] paramTypes = new Class[]{ServiceDispatcher.class};
            Object[] params = new Object[]{this.dispatcher};
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> c = loader.loadClass(className);
                Constructor<?> cn = c.getConstructor(paramTypes);
                engine = (GenericEngine)cn.newInstance(params);
            }
            catch (Exception e) {
                throw new GenericServiceException(e.getMessage(), e);
            }
            if (engine == null) return engine;
            this.engines.put(engineName, engine);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return engine;
        }
    }
}

