/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.serialize.SerializeException;
import org.ofbiz.core.serialize.XmlSerializer;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.engine.GenericEngine;
import org.ofbiz.core.service.job.GenericServiceJob;
import org.ofbiz.core.service.job.JobManagerException;
import org.ofbiz.core.service.job.PersistedServiceJob;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilDateTime;
import org.ofbiz.core.util.UtilMisc;

public abstract class GenericAsyncEngine
implements GenericEngine {
    protected ServiceDispatcher dispatcher = null;

    protected GenericAsyncEngine(ServiceDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public abstract Map runSync(String var1, ModelService var2, Map var3) throws GenericServiceException;

    public abstract void runSyncIgnore(String var1, ModelService var2, Map var3) throws GenericServiceException;

    public void runAsync(String localName, ModelService modelService, Map context, boolean persist) throws GenericServiceException {
        this.runAsync(localName, modelService, context, null, persist);
    }

    public void runAsync(String localName, ModelService modelService, Map context, GenericRequester requester, boolean persist) throws GenericServiceException {
        DispatchContext dctx = this.dispatcher.getLocalContext(localName);
        GenericServiceJob job = null;
        if (persist) {
            if (this.dispatcher.getDelegator() == null) {
                throw new GenericServiceException("No reference to delegator; cannot run persisted services.");
            }
            TransactionManager tm = TransactionFactory.getTransactionManager();
            if (tm == null) {
                throw new GenericServiceException("Cannot get the transaction manager; cannot run persisted services.");
            }
            Transaction parentTrans = null;
            try {
                parentTrans = tm.suspend();
            }
            catch (SystemException se) {
                Debug.logError((Throwable)se, (String)("Cannot suspend transaction: " + se.getMessage()));
            }
            String exceptionMessage = "Cannot begin asynchronous service.";
            GenericValue jobV = null;
            try {
                LinkedList<GenericValue> toBeStored = new LinkedList<GenericValue>();
                String dataId = this.dispatcher.getDelegator().getNextSeqId("RuntimeData").toString();
                GenericValue runtimeData = this.dispatcher.getDelegator().makeValue("RuntimeData", UtilMisc.toMap((String)"runtimeDataId", (Object)dataId));
                runtimeData.set("runtimeInfo", (Object)XmlSerializer.serialize((Object)context));
                toBeStored.add(runtimeData);
                String jobName = new String(new Long(new Date().getTime()).toString());
                Map jFields = UtilMisc.toMap((String)"jobName", (Object)jobName, (String)"runTime", (Object)UtilDateTime.nowTimestamp(), (String)"serviceName", (Object)modelService.name, (String)"loaderName", (Object)localName, (String)"runtimeDataId", (Object)dataId);
                jobV = this.dispatcher.getDelegator().makeValue("JobSandbox", jFields);
                toBeStored.add(jobV);
                this.dispatcher.getDelegator().storeAll(toBeStored);
            }
            catch (GenericEntityException e) {
                this.resumeTransaction(tm, parentTrans);
                throw new GenericServiceException(exceptionMessage, e);
            }
            catch (SerializeException e) {
                this.resumeTransaction(tm, parentTrans);
                throw new GenericServiceException(exceptionMessage, e);
            }
            catch (FileNotFoundException e) {
                this.resumeTransaction(tm, parentTrans);
                throw new GenericServiceException(exceptionMessage, e);
            }
            catch (IOException e) {
                this.resumeTransaction(tm, parentTrans);
                throw new GenericServiceException(exceptionMessage, e);
            }
            this.resumeTransaction(tm, parentTrans);
            if (jobV == null) {
                throw new GenericServiceException("Problems creating job.");
            }
            job = new PersistedServiceJob(dctx, jobV, requester);
        } else {
            String name = new Long(new Date().getTime()).toString();
            job = new GenericServiceJob(dctx, name, modelService.name, context, requester);
        }
        try {
            this.dispatcher.getJobManager().runJob(job);
        }
        catch (JobManagerException jse) {
            throw new GenericServiceException("Cannot run job.", (Throwable)((Object)jse));
        }
    }

    private void resumeTransaction(TransactionManager tm, Transaction trans) throws GenericServiceException {
        if (trans == null) {
            return;
        }
        try {
            tm.resume(trans);
        }
        catch (InvalidTransactionException ite) {
            throw new GenericServiceException("Cannot resume transaction", ite);
        }
        catch (SystemException se) {
            throw new GenericServiceException("Unexpected transaction error", se);
        }
    }
}

