/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import bsh.EvalError;
import bsh.Interpreter;
import java.net.URL;
import java.util.Map;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.engine.GenericAsyncEngine;
import org.ofbiz.core.util.HttpClient;
import org.ofbiz.core.util.HttpClientException;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilURL;

public final class BeanShellEngine
extends GenericAsyncEngine {
    public static UtilCache scriptCache = new UtilCache("BeanShellScripts", 0L, 0L);

    public BeanShellEngine(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    public void runSyncIgnore(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Map result = this.runSync(localName, modelService, context);
    }

    public Map runSync(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Object result = this.serviceInvoker(localName, modelService, context);
        if (result == null || !(result instanceof Map)) {
            throw new GenericServiceException("Service did not return expected result");
        }
        return (Map)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object serviceInvoker(String localName, ModelService modelService, Map context) throws GenericServiceException {
        if (modelService.location == null || modelService.invoke == null) {
            throw new GenericServiceException("Cannot locate service to invoke");
        }
        DispatchContext dctx = this.dispatcher.getLocalContext(localName);
        ClassLoader cl = null;
        cl = dctx == null ? this.getClass().getClassLoader() : dctx.getClassLoader();
        String script = (String)scriptCache.get((Object)(localName + "_" + modelService.location));
        if (script == null) {
            BeanShellEngine beanShellEngine = this;
            synchronized (beanShellEngine) {
                script = (String)scriptCache.get((Object)(localName + "_" + modelService.location));
                if (script == null) {
                    URL scriptUrl = UtilURL.fromResource((String)modelService.location, (ClassLoader)cl);
                    if (scriptUrl != null) {
                        try {
                            HttpClient http = new HttpClient(scriptUrl);
                            script = http.get();
                        }
                        catch (HttpClientException e) {
                            throw new GenericServiceException("Cannot read script from resource", e);
                        }
                    } else {
                        throw new GenericServiceException("Cannot read script, resource [" + modelService.location + "] not found");
                    }
                    if (script == null || script.length() < 2) {
                        throw new GenericServiceException("Null or empty script");
                    }
                    scriptCache.put((Object)(localName + "_" + modelService.location), (Object)script);
                }
            }
        }
        Interpreter bsh = new Interpreter();
        Map result = null;
        try {
            bsh.set("dctx", (Object)dctx);
            bsh.set("context", (Object)context);
            bsh.eval(script);
            Object bshResult = bsh.get("result");
            if (bshResult != null && bshResult instanceof Map) {
                context.putAll((Map)bshResult);
            }
            result = modelService.makeValid(context, "OUT");
        }
        catch (EvalError e) {
            throw new GenericServiceException("BeanShell script threw an exception", e);
        }
        return result;
    }
}

