/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.engine.GenericAsyncEngine;
import org.ofbiz.core.util.HttpClient;
import org.ofbiz.core.util.HttpClientException;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilURL;

public class BSFEngine
extends GenericAsyncEngine {
    public static final String module = BSFEngine.class.getName();
    public static UtilCache scriptCache = new UtilCache("BSFScripts", 0L, 0L);

    public BSFEngine(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    public void runSyncIgnore(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Map result = this.runSync(localName, modelService, context);
    }

    public Map runSync(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Object result = this.serviceInvoker(localName, modelService, context);
        if (result == null || !(result instanceof Map)) {
            throw new GenericServiceException("Service did not return expected result");
        }
        return (Map)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object serviceInvoker(String localName, ModelService modelService, Map context) throws GenericServiceException {
        if (modelService.location == null || modelService.invoke == null) {
            throw new GenericServiceException("Cannot locate service to invoke");
        }
        DispatchContext dctx = this.dispatcher.getLocalContext(localName);
        ClassLoader cl = null;
        cl = dctx == null ? this.getClass().getClassLoader() : dctx.getClassLoader();
        BSFManager mgr = new BSFManager();
        mgr.setClassLoader(cl);
        Set keySet = context.keySet();
        for (String key : keySet) {
            Object value = context.get(key);
            mgr.registerBean(key, value);
        }
        mgr.registerBean("response", new HashMap());
        com.ibm.bsf.BSFEngine bsfEngine = null;
        try {
            bsfEngine = mgr.loadScriptingEngine(modelService.engineName);
        }
        catch (BSFException e) {
            throw new GenericServiceException("Problems loading com.ibm.bsf.BSFEngine: " + modelService.engineName, e);
        }
        String script = (String)scriptCache.get((Object)(localName + "_" + modelService.location));
        if (script == null) {
            BSFEngine bSFEngine = this;
            synchronized (bSFEngine) {
                script = (String)scriptCache.get((Object)(localName + "_" + modelService.location));
                if (script == null) {
                    URL scriptUrl = UtilURL.fromResource((String)modelService.location, (ClassLoader)cl);
                    if (scriptUrl != null) {
                        try {
                            HttpClient http = new HttpClient(scriptUrl);
                            script = http.get();
                        }
                        catch (HttpClientException e) {
                            throw new GenericServiceException("Cannot read script from resource", e);
                        }
                    } else {
                        throw new GenericServiceException("Cannot read script, resource [" + modelService.location + "] not found");
                    }
                    if (script == null || script.length() < 2) {
                        throw new GenericServiceException("Null or empty script");
                    }
                    scriptCache.put((Object)(localName + "_" + modelService.location), (Object)script);
                }
            }
        }
        try {
            bsfEngine.exec(modelService.location, 0, 0, (Object)script);
        }
        catch (BSFException e) {
            throw new GenericServiceException("Script invocation error", e);
        }
        return mgr.lookupBean("response");
    }
}

