/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.eca;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.eca.ServiceEcaRule;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class ServiceEcaUtil {
    public static final String module = ServiceEcaUtil.class.getName();
    public static Map ecaCache = null;

    public static void reloadConfig() {
        ecaCache = null;
        ServiceEcaUtil.readConfig();
    }

    public static void readConfig() {
        ecaCache = new HashMap();
        Element rootElement = null;
        try {
            rootElement = ServiceConfigUtil.getXmlRootElement();
        }
        catch (GenericConfigException e) {
            Debug.logError((Throwable)e, (String)"Error getting Service Engine XML root element", (String)module);
            return;
        }
        List serviceEcasElements = UtilXml.childElementList((Element)rootElement, (String)"service-ecas");
        for (Element serviceEcasElement : serviceEcasElements) {
            ResourceHandler handler = new ResourceHandler("serviceengine.xml", serviceEcasElement);
            ServiceEcaUtil.addEcaDefinitions(handler);
        }
    }

    public static void addEcaDefinitions(ResourceHandler handler) {
        Element rootElement = null;
        try {
            rootElement = handler.getDocument().getDocumentElement();
        }
        catch (GenericConfigException e) {
            Debug.logError((Throwable)e);
            return;
        }
        List ecaList = UtilXml.childElementList((Element)rootElement, (String)"eca");
        Iterator ecaIt = ecaList.iterator();
        int numDefs = 0;
        while (ecaIt.hasNext()) {
            Element e = (Element)ecaIt.next();
            String serviceName = e.getAttribute("service");
            String eventName = e.getAttribute("event");
            HashMap eventMap = (HashMap)ecaCache.get(serviceName);
            LinkedList<ServiceEcaRule> rules = null;
            if (eventMap == null) {
                eventMap = new HashMap();
                rules = new LinkedList<ServiceEcaRule>();
                ecaCache.put(serviceName, eventMap);
                eventMap.put(eventName, rules);
            } else {
                rules = (LinkedList<ServiceEcaRule>)eventMap.get(eventName);
                if (rules == null) {
                    rules = new LinkedList();
                    eventMap.put(eventName, rules);
                }
            }
            rules.add(new ServiceEcaRule(e));
            ++numDefs;
        }
        Debug.logImportant((String)("Loaded " + numDefs + " Service ECA definitions from " + handler.getLocation() + " in loader " + handler.getLoaderName()), (String)module);
    }

    public static Map getServiceEventMap(String serviceName) {
        if (ecaCache == null) {
            ServiceEcaUtil.readConfig();
        }
        return (Map)ecaCache.get(serviceName);
    }

    public static void evalRules(String serviceName, Map eventMap, String event, DispatchContext dctx, Map context, Map result, boolean isError) throws GenericServiceException {
        if (eventMap == null) {
            eventMap = ServiceEcaUtil.getServiceEventMap(serviceName);
        }
        if (eventMap == null || eventMap.size() == 0) {
            return;
        }
        List rules = (List)eventMap.get(event);
        if (rules == null || rules.size() == 0) {
            return;
        }
        Iterator i = rules.iterator();
        if (i.hasNext() && Debug.verboseOn()) {
            Debug.logVerbose((String)("Running ECA (" + event + ")."), (String)module);
        }
        while (i.hasNext()) {
            ServiceEcaRule eca = (ServiceEcaRule)i.next();
            eca.eval(serviceName, dctx, context, result, isError);
        }
    }
}

