/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.eca;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.eca.ServiceEcaAction;
import org.ofbiz.core.service.eca.ServiceEcaCondition;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class ServiceEcaRule {
    String serviceName;
    String eventName;
    boolean runOnError;
    List conditions = new LinkedList();
    List actions = new LinkedList();

    protected ServiceEcaRule() {
    }

    public ServiceEcaRule(Element eca) {
        this.serviceName = eca.getAttribute("service");
        this.eventName = eca.getAttribute("event");
        this.runOnError = "true".equals(eca.getAttribute("run-on-error"));
        List condList = UtilXml.childElementList((Element)eca, (String)"condition");
        Iterator ci = condList.iterator();
        while (ci.hasNext()) {
            this.conditions.add(new ServiceEcaCondition((Element)ci.next(), true));
        }
        List condFList = UtilXml.childElementList((Element)eca, (String)"condition-field");
        Iterator cfi = condFList.iterator();
        while (cfi.hasNext()) {
            this.conditions.add(new ServiceEcaCondition((Element)cfi.next(), false));
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Conditions: " + this.conditions));
        }
        List actList = UtilXml.childElementList((Element)eca, (String)"action");
        Iterator ai = actList.iterator();
        while (ai.hasNext()) {
            this.actions.add(new ServiceEcaAction((Element)ai.next()));
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Actions: " + this.actions));
        }
    }

    public void eval(String serviceName, DispatchContext dctx, Map context, Map result, boolean isError) throws GenericServiceException {
        if (isError && !this.runOnError) {
            return;
        }
        boolean allCondTrue = true;
        for (ServiceEcaCondition ec : this.conditions) {
            if (ec.eval(serviceName, dctx, context)) continue;
            allCondTrue = false;
            break;
        }
        if (allCondTrue) {
            for (ServiceEcaAction ea : this.actions) {
                ea.runAction(serviceName, dctx, context, result);
            }
        }
    }
}

