/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.eca;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.ObjectType;
import org.w3c.dom.Element;

public class ServiceEcaCondition {
    protected String lhsValueName;
    protected String rhsValueName;
    protected String lhsMapName;
    protected String rhsMapName;
    protected String operator;
    protected String compareType;
    protected String format;
    protected boolean constant = false;

    protected ServiceEcaCondition() {
    }

    public ServiceEcaCondition(Element condition, boolean constant) {
        this.lhsValueName = condition.getAttribute("field-name");
        this.lhsMapName = condition.getAttribute("map-name");
        this.constant = constant;
        if (constant) {
            this.rhsValueName = condition.getAttribute("value");
            this.rhsMapName = null;
        } else {
            this.rhsValueName = condition.getAttribute("to-field-name");
            this.rhsMapName = condition.getAttribute("to-map-name");
        }
        this.operator = condition.getAttribute("operator");
        this.compareType = condition.getAttribute("type");
        this.format = condition.getAttribute("format");
        if (this.lhsValueName == null) {
            this.lhsValueName = "";
        }
        if (this.rhsValueName == null) {
            this.rhsValueName = "";
        }
    }

    public boolean eval(String serviceName, DispatchContext dctx, Map context) throws GenericServiceException {
        String rhsValue;
        Object lhsValue;
        Map envMap;
        if (serviceName == null || dctx == null || context == null || dctx.getClassLoader() == null) {
            throw new GenericServiceException("Cannot have null Service, Context or DispatchContext!");
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)this.toString());
        }
        if (this.lhsMapName != null && this.lhsMapName.length() > 0) {
            try {
                if (!context.containsKey(this.lhsMapName)) {
                    Debug.logVerbose((String)("Map (" + this.lhsMapName + ") not found in context."));
                    return false;
                }
                envMap = (Map)context.get(this.lhsMapName);
                lhsValue = envMap.get(this.lhsValueName);
            }
            catch (ClassCastException e) {
                Debug.logVerbose((String)("Field (" + this.lhsMapName + ") is not a Map."));
                return false;
            }
        } else if (context.containsKey(this.lhsValueName)) {
            lhsValue = context.get(this.lhsValueName);
        } else {
            Debug.logVerbose((String)("Field (" + this.lhsValueName + ") is not found in context."));
            return false;
        }
        if (this.constant) {
            rhsValue = this.rhsValueName;
        } else if (this.rhsMapName != null && this.rhsMapName.length() > 0) {
            try {
                if (!context.containsKey(this.rhsMapName)) {
                    Debug.logVerbose((String)("Map (" + this.rhsMapName + ") not found in context."));
                    return false;
                }
                envMap = (Map)context.get(this.rhsMapName);
                rhsValue = envMap.get(this.rhsValueName);
            }
            catch (ClassCastException e) {
                Debug.logVerbose((String)("Field (" + this.rhsMapName + ") is not a Map."));
                return false;
            }
        } else if (context.containsKey(this.rhsValueName)) {
            rhsValue = context.get(this.rhsValueName);
        } else {
            Debug.logVerbose((String)("Field (" + this.rhsValueName + ") is not found in context."));
            return false;
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Comparing : " + lhsValue + " <> " + rhsValue));
        }
        LinkedList messages = new LinkedList();
        Boolean cond = ObjectType.doRealCompare(lhsValue, (Object)rhsValue, (String)this.operator, (String)this.compareType, (String)this.format, messages, null, (ClassLoader)dctx.getClassLoader());
        if (messages.size() > 0) {
            Iterator m = messages.iterator();
            while (m.hasNext()) {
                Debug.logWarning((String)((String)m.next()));
            }
        }
        if (cond != null) {
            return cond;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[" + this.lhsMapName + "]");
        buf.append("[" + this.lhsValueName + "]");
        buf.append("[" + this.operator + "]");
        buf.append("[" + this.rhsMapName + "]");
        buf.append("[" + this.rhsValueName + "]");
        buf.append("[" + this.constant + "]");
        buf.append("[" + this.compareType + "]");
        buf.append("[" + this.format + "]");
        return buf.toString();
    }
}

