/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.util.UtilValidate;

public class ServiceUtil {
    public static Map returnError(String errorMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("responseMessage", "error");
        if (errorMessage != null) {
            result.put("errorMessage", errorMessage);
        }
        return result;
    }

    public static Map returnError(List errorMessageList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("responseMessage", "error");
        if (errorMessageList != null) {
            result.put("errorMessageList", errorMessageList);
        }
        return result;
    }

    public static Map returnSuccess(String successMessage) {
        return ServiceUtil.returnMessage("success", successMessage);
    }

    public static Map returnSuccess() {
        return ServiceUtil.returnMessage("success", null);
    }

    public static Map returnMessage(String code, String message) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (code != null) {
            result.put("responseMessage", code);
        }
        if (message != null) {
            result.put("successMessage", message);
        }
        return result;
    }

    public static String getPartyIdCheckSecurity(GenericValue userLogin, Security security, Map context, Map result, String secEntity, String secOperation) {
        String partyId = (String)context.get("partyId");
        if (partyId == null || partyId.length() == 0) {
            partyId = userLogin.getString("partyId");
        }
        if (partyId == null || partyId.length() == 0) {
            result.put("responseMessage", "error");
            result.put("errorMessage", "Party ID missing");
            return partyId;
        }
        if (!partyId.equals(userLogin.getString("partyId")) && !security.hasEntityPermission(secEntity, secOperation, userLogin)) {
            result.put("responseMessage", "error");
            result.put("errorMessage", "You do not have permission to perform this operation for this party");
            return partyId;
        }
        return partyId;
    }

    public static void getMessages(HttpServletRequest request, Map result, String defaultMessage, String msgPrefix, String msgSuffix, String errorPrefix, String errorSuffix, String successPrefix, String successSuffix) {
        String successMessage;
        String errorMessage = ServiceUtil.makeErrorMessage(result, msgPrefix, msgSuffix, errorPrefix, errorSuffix);
        if (UtilValidate.isNotEmpty((String)errorMessage)) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)errorMessage);
        }
        if (UtilValidate.isNotEmpty((String)(successMessage = ServiceUtil.makeSuccessMessage(result, msgPrefix, msgSuffix, successPrefix, successSuffix)))) {
            request.setAttribute("_EVENT_MESSAGE_", (Object)successMessage);
        }
        if (UtilValidate.isEmpty((String)errorMessage) && UtilValidate.isEmpty((String)successMessage) && UtilValidate.isNotEmpty((String)defaultMessage)) {
            request.setAttribute("_EVENT_MESSAGE_", (Object)defaultMessage);
        }
    }

    public static String makeErrorMessage(Map result, String msgPrefix, String msgSuffix, String errorPrefix, String errorSuffix) {
        String errorMsg = (String)result.get("errorMessage");
        List errorMsgList = (List)result.get("errorMessageList");
        Map errorMsgMap = (Map)result.get("errorMessageMap");
        StringBuffer outMsg = new StringBuffer();
        if (errorMsg != null) {
            if (msgPrefix != null) {
                outMsg.append(msgPrefix);
            }
            outMsg.append(errorMsg);
            if (msgSuffix != null) {
                outMsg.append(msgSuffix);
            }
        }
        outMsg.append(ServiceUtil.makeMessageList(errorMsgList, msgPrefix, msgSuffix));
        if (errorMsgMap != null) {
            for (Map.Entry entry : errorMsgMap.entrySet()) {
                outMsg.append(msgPrefix);
                outMsg.append(entry.getKey());
                outMsg.append(": ");
                outMsg.append(entry.getValue());
                outMsg.append(msgSuffix);
            }
        }
        if (outMsg.length() > 0) {
            StringBuffer strBuf = new StringBuffer();
            if (errorPrefix != null) {
                strBuf.append(errorPrefix);
            }
            strBuf.append(outMsg.toString());
            if (errorSuffix != null) {
                strBuf.append(errorSuffix);
            }
            return strBuf.toString();
        }
        return null;
    }

    public static String makeSuccessMessage(Map result, String msgPrefix, String msgSuffix, String successPrefix, String successSuffix) {
        String successMsg = (String)result.get("successMessage");
        List successMsgList = (List)result.get("successMessageList");
        StringBuffer outMsg = new StringBuffer();
        outMsg.append(ServiceUtil.makeMessageList(successMsgList, msgPrefix, msgSuffix));
        if (successMsg != null) {
            if (msgPrefix != null) {
                outMsg.append(msgPrefix);
            }
            outMsg.append(successMsg);
            if (msgSuffix != null) {
                outMsg.append(msgSuffix);
            }
        }
        if (outMsg.length() > 0) {
            StringBuffer strBuf = new StringBuffer();
            if (successPrefix != null) {
                strBuf.append(successPrefix);
            }
            strBuf.append(outMsg.toString());
            if (successSuffix != null) {
                strBuf.append(successSuffix);
            }
            return strBuf.toString();
        }
        return null;
    }

    public static String makeMessageList(List msgList, String msgPrefix, String msgSuffix) {
        StringBuffer outMsg = new StringBuffer();
        if (msgList != null && msgList.size() > 0) {
            for (String curMsg : msgList) {
                if (msgPrefix != null) {
                    outMsg.append(msgPrefix);
                }
                outMsg.append(curMsg);
                if (msgSuffix == null) continue;
                outMsg.append(msgSuffix);
            }
        }
        return outMsg.toString();
    }
}

