/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.service.ModelParam;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModelServiceReader {
    public static final String module = ModelServiceReader.class.getName();
    protected static UtilCache readersUrl = new UtilCache("service.ModelServiceReader.ByURL", 0L, 0L);
    protected static UtilCache readersLoader = new UtilCache("service.ModelServiceReader.ByResourceLoader", 0L, 0L);
    protected boolean isFromURL;
    protected URL readerURL = null;
    protected ResourceHandler handler = null;
    protected Map modelServices = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelServiceReader getModelServiceReader(URL readerURL) {
        ModelServiceReader reader = null;
        reader = (ModelServiceReader)readersUrl.get((Object)readerURL);
        if (reader != null) return reader;
        Class<ModelServiceReader> clazz = ModelServiceReader.class;
        synchronized (ModelServiceReader.class) {
            reader = (ModelServiceReader)readersUrl.get((Object)readerURL);
            if (reader != null) return reader;
            reader = new ModelServiceReader(readerURL);
            readersUrl.put((Object)readerURL, (Object)reader);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelServiceReader getModelServiceReader(ResourceHandler handler) {
        ModelServiceReader reader = null;
        reader = (ModelServiceReader)readersLoader.get((Object)handler);
        if (reader != null) return reader;
        Class<ModelServiceReader> clazz = ModelServiceReader.class;
        synchronized (ModelServiceReader.class) {
            reader = (ModelServiceReader)readersLoader.get((Object)handler);
            if (reader != null) return reader;
            reader = new ModelServiceReader(handler);
            readersLoader.put((Object)handler, (Object)reader);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return reader;
        }
    }

    protected ModelServiceReader(URL readerURL) {
        this.isFromURL = true;
        this.readerURL = readerURL;
        this.handler = null;
        this.getModelServices();
    }

    protected ModelServiceReader(ResourceHandler handler) {
        this.isFromURL = false;
        this.readerURL = null;
        this.handler = handler;
        this.getModelServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getModelServices() {
        if (this.modelServices != null) return this.modelServices;
        Class<ModelServiceReader> clazz = ModelServiceReader.class;
        synchronized (ModelServiceReader.class) {
            Element docElement;
            if (this.modelServices != null) return this.modelServices;
            this.modelServices = new HashMap();
            UtilTimer utilTimer = new UtilTimer();
            Document document = null;
            if (this.isFromURL) {
                document = this.getDocument(this.readerURL);
                if (document == null) {
                    this.modelServices = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            } else {
                try {
                    document = this.handler.getDocument();
                }
                catch (GenericConfigException e) {
                    Debug.logError((Throwable)e, (String)"Error getting XML document from resource");
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
            if (this.isFromURL) {
                // empty if block
            }
            if ((docElement = document.getDocumentElement()) == null) {
                this.modelServices = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            docElement.normalize();
            Node curChild = docElement.getFirstChild();
            int i = 0;
            if (curChild != null) {
                if (this.isFromURL) {
                    utilTimer.timerString("Before start of service loop in file " + this.readerURL);
                } else {
                    utilTimer.timerString("Before start of service loop in " + this.handler);
                }
                boolean servicesLoaded = false;
                do {
                    ModelService service;
                    if (curChild.getNodeType() != 1 || !"service".equals(curChild.getNodeName())) continue;
                    ++i;
                    Element curService = (Element)curChild;
                    String serviceName = UtilXml.checkEmpty((String)curService.getAttribute("name"));
                    if (this.modelServices.containsKey(serviceName)) {
                        Debug.logWarning((String)("WARNING: Service " + serviceName + " is defined more than once, " + "most recent will over-write previous definition(s)"), (String)module);
                    }
                    if ((service = this.createModelService(curService)) != null) {
                        this.modelServices.put(serviceName, service);
                        continue;
                    }
                    Debug.logWarning((String)("-- -- SERVICE ERROR:getModelService: Could not create service for serviceName: " + serviceName), (String)module);
                } while ((curChild = curChild.getNextSibling()) != null);
            } else {
                Debug.logWarning((String)"No child nodes found.", (String)module);
            }
            if (this.isFromURL) {
                utilTimer.timerString("Finished file " + this.readerURL + " - Total Services: " + i + " FINISHED");
                Debug.logImportant((String)("Loaded " + i + " Service definitions from " + this.readerURL));
            } else {
                utilTimer.timerString("Finished document in " + this.handler + " - Total Services: " + i + " FINISHED");
                Debug.logImportant((String)("Loaded " + i + " Service definitions from " + this.handler.getLocation() + " in loader " + this.handler.getLoaderName()));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.modelServices;
        }
    }

    public ModelService getModelService(String serviceName) {
        Map ec = this.getModelServices();
        if (ec != null) {
            return (ModelService)ec.get(serviceName);
        }
        return null;
    }

    public Iterator getServiceNamesIterator() {
        Collection collection = this.getServiceNames();
        if (collection != null) {
            return collection.iterator();
        }
        return null;
    }

    public Collection getServiceNames() {
        Map ec = this.getModelServices();
        return ec.keySet();
    }

    protected ModelService createModelService(Element serviceElement) {
        ModelService service = new ModelService();
        service.name = UtilXml.checkEmpty((String)serviceElement.getAttribute("name"));
        service.engineName = UtilXml.checkEmpty((String)serviceElement.getAttribute("engine"));
        service.location = UtilXml.checkEmpty((String)serviceElement.getAttribute("location"));
        service.invoke = UtilXml.checkEmpty((String)serviceElement.getAttribute("invoke"));
        service.auth = "true".equalsIgnoreCase(serviceElement.getAttribute("auth"));
        service.export = "true".equalsIgnoreCase(serviceElement.getAttribute("export"));
        service.validate = !"false".equalsIgnoreCase(serviceElement.getAttribute("validate"));
        service.useTransaction = !"false".equalsIgnoreCase(serviceElement.getAttribute("use-transaction"));
        service.requireNewTransaction = !"false".equalsIgnoreCase(serviceElement.getAttribute("require-new-transaction"));
        service.description = this.getCDATADef(serviceElement, "description");
        service.nameSpace = this.getCDATADef(serviceElement, "namespace");
        service.contextInfo = new HashMap();
        this.createImplDefs(serviceElement, service);
        this.createAttrDefs(serviceElement, service);
        return service;
    }

    protected String getCDATADef(Element baseElement, String tagName) {
        Node n;
        NodeList childNodes;
        String value = "";
        NodeList nl = baseElement.getElementsByTagName(tagName);
        if (nl.getLength() > 0 && (childNodes = (n = nl.item(0)).getChildNodes()).getLength() > 0) {
            Node cdata = childNodes.item(0);
            value = UtilXml.checkEmpty((String)cdata.getNodeValue());
        }
        return value;
    }

    protected void createImplDefs(Element baseElement, ModelService service) {
        List implElements = UtilXml.childElementList((Element)baseElement, (String)"implements");
        for (Element implement : implElements) {
            String serviceName = UtilXml.checkEmpty((String)implement.getAttribute("service"));
            if (serviceName.length() <= 0) continue;
            service.implServices.add(serviceName);
        }
    }

    protected void createAttrDefs(Element baseElement, ModelService service) {
        List paramElements = UtilXml.childElementList((Element)baseElement, (String)"attribute");
        for (Element attribute : paramElements) {
            ModelParam param = new ModelParam();
            param.name = UtilXml.checkEmpty((String)attribute.getAttribute("name"));
            param.type = UtilXml.checkEmpty((String)attribute.getAttribute("type"));
            param.mode = UtilXml.checkEmpty((String)attribute.getAttribute("mode"));
            param.optional = "true".equalsIgnoreCase(attribute.getAttribute("optional"));
            service.addParam(param);
        }
        ModelParam def = null;
        def = new ModelParam();
        def.name = "responseMessage";
        def.type = "String";
        def.mode = "OUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
        def = new ModelParam();
        def.name = "errorMessage";
        def.type = "String";
        def.mode = "OUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
        def = new ModelParam();
        def.name = "errorMessageList";
        def.type = "java.util.List";
        def.mode = "OUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
        def = new ModelParam();
        def.name = "successMessage";
        def.type = "String";
        def.mode = "OUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
        def = new ModelParam();
        def.name = "successMessageList";
        def.type = "java.util.List";
        def.mode = "OUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
        def = new ModelParam();
        def.name = "userLogin";
        def.type = "org.ofbiz.core.entity.GenericValue";
        def.mode = "INOUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
        def = new ModelParam();
        def.name = "locale";
        def.type = "java.util.Locale";
        def.mode = "INOUT";
        def.optional = true;
        def.internal = true;
        service.addParam(def);
    }

    protected Document getDocument(URL url) {
        if (url == null) {
            return null;
        }
        Document document = null;
        try {
            document = UtilXml.readXmlDocument((URL)url, (boolean)true);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }
}

