/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.ofbiz.core.util.HttpClientException;
import org.ofbiz.core.util.UtilProperties;

public class HttpClientJakarta {
    private int timeout = 30000;
    private boolean followRedirects = true;
    private String url = null;
    private Map parameters = null;
    private Map headers = null;
    private URL requestUrl = null;
    private HttpMethod httpMethod = null;

    public HttpClientJakarta() {
    }

    public HttpClientJakarta(URL url) {
        this.url = url.toExternalForm();
    }

    public HttpClientJakarta(String url) {
        this.url = url;
    }

    public HttpClientJakarta(String url, Map parameters) {
        this.url = url;
        this.parameters = parameters;
    }

    public HttpClientJakarta(URL url, Map parameters) {
        this.url = url.toExternalForm();
        this.parameters = parameters;
    }

    public HttpClientJakarta(String url, Map parameters, Map headers) {
        this.url = url;
        this.parameters = parameters;
        this.headers = headers;
    }

    public HttpClientJakarta(URL url, Map parameters, Map headers) {
        this.url = url.toExternalForm();
        this.parameters = parameters;
        this.headers = headers;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setUrl(URL url) {
        this.url = url.toExternalForm();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name, value);
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getUrl() {
        return this.url;
    }

    public String get() throws HttpClientException {
        return this.sendHttpRequest("get");
    }

    public InputStream getStream() throws HttpClientException {
        return this.sendHttpRequestStream("get");
    }

    public String post() throws HttpClientException {
        return this.sendHttpRequest("post");
    }

    public InputStream postStream() throws HttpClientException {
        return this.sendHttpRequestStream("post");
    }

    public String getResponseHeader(String header) throws HttpClientException {
        if (this.httpMethod == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.httpMethod.getResponseHeader(header).getValue();
    }

    public String getResponseHeaderFieldKey(int n) throws HttpClientException {
        if (this.httpMethod == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.httpMethod.getResponseHeaders()[n].getName();
    }

    public String getResponseHeaderField(int n) throws HttpClientException {
        if (this.httpMethod == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.httpMethod.getResponseHeaders()[n].getValue();
    }

    public byte[] getResponseContent() throws IOException, HttpClientException {
        if (this.httpMethod == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.httpMethod.getResponseBody();
    }

    private String sendHttpRequest(String method) throws HttpClientException {
        try {
            this.createHttpMethod(method);
            return this.httpMethod.getResponseBodyAsString();
        }
        catch (HttpException ex) {
            throw new HttpClientException("Error getting URL content", ex);
        }
        catch (IOException ex) {
            throw new HttpClientException("Error getting URL content", ex);
        }
    }

    private InputStream sendHttpRequestStream(String method) throws HttpClientException {
        try {
            this.createHttpMethod(method);
            return this.httpMethod.getResponseBodyAsStream();
        }
        catch (HttpException ex) {
            throw new HttpClientException("Error getting URL content", ex);
        }
        catch (IOException ex) {
            throw new HttpClientException("Error getting URL content", ex);
        }
    }

    private void createHttpMethod(String method) throws HttpClientException, HttpException, IOException {
        String protocol = UtilProperties.getPropertyValue("jsse.properties", "java.protocol.handler.pkgs", "NONE");
        String proxyHost = UtilProperties.getPropertyValue("jsse.properties", "https.proxyHost", "NONE");
        String proxyPort = UtilProperties.getPropertyValue("jsse.properties", "https.proxyPort", "NONE");
        String cypher = UtilProperties.getPropertyValue("jsse.properties", "https.cipherSuites", "NONE");
        if (protocol != null && !protocol.equals("NONE")) {
            System.setProperty("java.protocol.handler.pkgs", protocol);
        }
        if (proxyHost != null && !proxyHost.equals("NONE")) {
            System.setProperty("https.proxyHost", proxyHost);
        }
        if (proxyPort != null && !proxyPort.equals("NONE")) {
            System.setProperty("https.proxyPort", proxyPort);
        }
        if (cypher != null && !cypher.equals("NONE")) {
            System.setProperty("https.cipherSuites", cypher);
        }
        String arguments = null;
        Object in = null;
        if (this.url == null) {
            throw new HttpClientException("Cannot process a null URL.");
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            arguments = this.encodeArgs(this.parameters);
        }
        this.requestUrl = new URL(this.url);
        HttpClient commonsClient = new HttpClient();
        GetMethod httpMethod = null;
        if ("get".equalsIgnoreCase(method)) {
            httpMethod = new GetMethod(this.requestUrl.getPath());
        } else if ("put".equalsIgnoreCase(method)) {
            httpMethod = new PutMethod(this.requestUrl.getPath());
        } else if ("post".equalsIgnoreCase(method)) {
            httpMethod = new PostMethod(this.requestUrl.getPath());
        } else if ("delete".equalsIgnoreCase(method)) {
            httpMethod = new DeleteMethod(this.requestUrl.getPath());
        } else if ("head".equalsIgnoreCase(method)) {
            httpMethod = new HeadMethod(this.requestUrl.getPath());
        }
        if (method.equalsIgnoreCase("post")) {
            httpMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        }
        if (this.headers != null && this.headers.size() > 0) {
            Set headerSet = this.headers.entrySet();
            Iterator i = headerSet.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String headerName = (String)((Object)i.next());
                String headerValue = (String)this.headers.get(headerName);
                httpMethod.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        httpMethod.setQueryString(arguments);
        commonsClient.startSession(this.requestUrl);
        httpMethod.setFollowRedirects(this.followRedirects);
        int resultCode = commonsClient.executeMethod((HttpMethod)httpMethod);
    }

    private String encodeArgs(Map args) {
        StringBuffer buf = new StringBuffer();
        Set names = args.keySet();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)args.get(name);
            buf.append(URLEncoder.encode(name));
            buf.append("=");
            buf.append(URLEncoder.encode(value));
            if (!i.hasNext()) continue;
            buf.append("&");
        }
        return buf.toString();
    }
}

