/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityConfigUtil {
    public static final String SECURITY_CONFIG_XML_FILENAME = "security.xml";
    protected static Map securityInfos = new HashMap();

    public static Element getXmlRootElement() throws GenericConfigException {
        return ResourceLoader.getXmlRootElement(SECURITY_CONFIG_XML_FILENAME);
    }

    public static Document getXmlDocument() throws GenericConfigException {
        return ResourceLoader.getXmlDocument(SECURITY_CONFIG_XML_FILENAME);
    }

    public static void initialize(Element rootElement) throws GenericConfigException {
        List childElements = null;
        Iterator elementIter = null;
        childElements = UtilXml.childElementList(rootElement, "security");
        for (Element curElement : childElements) {
            SecurityInfo securityInfo = new SecurityInfo(curElement);
            if (Debug.verboseOn()) {
                Debug.logVerbose("LOADED SECURITY CONFIG FROM XML -  NAME: " + securityInfo.name + " ClassName: " + securityInfo.className);
            }
            securityInfos.put(securityInfo.name, securityInfo);
        }
    }

    public static SecurityInfo getSecurityInfo(String name) {
        return (SecurityInfo)securityInfos.get(name);
    }

    static {
        try {
            SecurityConfigUtil.initialize(SecurityConfigUtil.getXmlRootElement());
        }
        catch (Exception e) {
            Debug.logError(e, "Error loading Security config XML file security.xml");
        }
    }

    public static class SecurityInfo {
        public String name;
        public String className;

        public SecurityInfo(Element element) {
            this.name = element.getAttribute("name");
            this.className = element.getAttribute("class");
        }
    }
}

