/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.TransportErrorMessage;
import com.atlassian.security.auth.trustedapps.request.TrustedRequest;

public class TrustedApplicationUtils {
    public static void addRequestParameters(EncryptedCertificate certificate, TrustedRequest request) {
        request.addRequestParameter("X-Seraph-Trusted-App-ID", certificate.getID());
        request.addRequestParameter("X-Seraph-Trusted-App-Cert", certificate.getCertificate());
        request.addRequestParameter("X-Seraph-Trusted-App-Key", certificate.getSecretKey());
        request.addRequestParameter("X-Seraph-Trusted-App-Version", Constant.VERSION.toString());
        request.addRequestParameter("X-Seraph-Trusted-App-Magic", certificate.getMagicNumber());
    }

    public static TransportErrorMessage parseError(String errorMessage) {
        return TransportErrorMessage.PARSER.parse(errorMessage);
    }

    public static void validateMagicNumber(String msg, String appId, Integer protocolVersion, String magicNumber) throws InvalidCertificateException {
        if (protocolVersion != null && !Constant.MAGIC.equals(magicNumber)) {
            throw new InvalidCertificateException(new TransportErrorMessage.BadMagicNumber(msg, appId));
        }
    }

    public static final class Header {
        private static final String PREFIX = "X-Seraph-Trusted-App-";

        private Header() {
        }

        public static final class Response {
            public static final String ERROR = "X-Seraph-Trusted-App-Error";
            public static final String STATUS = "X-Seraph-Trusted-App-Status";

            private Response() {
            }
        }

        public static final class Request {
            public static final String ID = "X-Seraph-Trusted-App-ID";
            public static final String SECRET_KEY = "X-Seraph-Trusted-App-Key";
            public static final String CERTIFICATE = "X-Seraph-Trusted-App-Cert";
            public static final String VERSION = "X-Seraph-Trusted-App-Version";
            public static final String MAGIC = "X-Seraph-Trusted-App-Magic";

            private Request() {
            }
        }
    }

    public static final class Constant {
        public static final Integer VERSION = new Integer(1);
        public static final String MAGIC = String.valueOf(-1159983122);
        public static final String CHARSET_NAME = "utf-8";
        public static final String CERTIFICATE_URL_PATH = "/admin/appTrustCertificate";

        private Constant() {
        }
    }
}

