/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.sax;

import electric.util.io.FastBufferedReader;
import electric.util.io.FastStringReader;
import electric.util.io.Streams;
import electric.util.lex.Lex;
import electric.util.string.Strings;
import electric.xml.IXMLConstants;
import electric.xml.sax.ISAXConstants;
import electric.xml.sax.SAXScope;
import electric.xml.sax.SAXSink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class SAXParser
implements XMLReader,
Locator,
IXMLConstants,
ISAXConstants {
    public static int IGNORE_WHITESPACE = 1;
    private static final SAXSink sink = new SAXSink();
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private ContentHandler contentHandler = sink;
    private DTDHandler dtdHandler = sink;
    private ErrorHandler errorHandler = sink;
    private EntityResolver entityResolver;
    private int flags;
    private Lex lex;
    private boolean ignoreWhitespace;
    private boolean standalone;
    private String version;
    private String encoding;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        return name.equals("http://xml.org/sax/features/resolve-dtd-uris");
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!name.equals("http://www.themindelectric.com/sax/features/keep-whitespace")) {
            throw new SAXNotSupportedException("feature " + name + " is not currently supported");
        }
        this.flags = value ? 1 : 0;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("property " + name + " is not currently supported");
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("property " + name + " is not currently supported");
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler == null ? sink : handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler == null ? sink : handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler == null ? sink : handler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        Reader reader = input.getCharacterStream();
        if (reader != null) {
            this.parse(reader);
            return;
        }
        InputStream stream = input.getByteStream();
        if (stream != null) {
            this.parse(stream);
            return;
        }
        URL url = new URL(input.getSystemId());
        this.parse(url.openStream());
    }

    public void parse(String url) throws IOException, SAXException {
        this.parse(new InputSource(url));
    }

    public void parse(byte[] bytes) throws IOException, SAXException {
        this.parse(new FastStringReader(Strings.toString(bytes)));
    }

    public void parse(InputStream stream) throws IOException, SAXException {
        this.parse(new FastBufferedReader(Streams.getReader(stream)));
    }

    public void parse(File file) throws IOException, SAXException {
        this.parse(new FastBufferedReader(Streams.getReader(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Reader reader) throws IOException, SAXException {
        this.ignoreWhitespace = (this.flags & IGNORE_WHITESPACE) != 0;
        this.lex = new Lex(reader, "<>=/:", 1);
        try {
            this.parse();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                reader.close();
            }
            catch (IOException exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException exception) {}
    }

    private void parse() throws IOException, SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        int elements = 0;
        while (true) {
            StringBuffer whitespace;
            if ((whitespace = this.lex.readWhitespace()) != null) {
                char[] chars = whitespace.toString().toCharArray();
                if (this.ignoreWhitespace) {
                    this.contentHandler.ignorableWhitespace(chars, 0, chars.length);
                } else {
                    this.contentHandler.characters(chars, 0, chars.length);
                }
            }
            this.lex.mark(2);
            int ch1 = this.lex.peekRead();
            int ch2 = this.lex.peekRead();
            this.lex.reset();
            if (ch1 == -1) break;
            if (ch2 == 33 && this.lex.peekString("<!--")) {
                this.parseComment();
                continue;
            }
            if (ch2 == 33 && this.lex.peekString("<!DOCTYPE")) {
                this.parseDocType();
                continue;
            }
            if (ch2 == 63 && this.lex.peekString("<?xml ")) {
                this.parseXMLDecl();
                continue;
            }
            if (ch2 == 63) {
                this.parseInstruction();
                continue;
            }
            this.parseElement(null);
            ++elements;
        }
        if (elements != 1) {
            throw new SAXException("the document does not have exactly one root");
        }
        this.lex.skipWhitespace();
        if (this.lex.read() != -1) {
            throw new SAXException("extra stuff at the end");
        }
        this.contentHandler.endDocument();
    }

    private void parseComment() throws IOException {
        this.lex.skip("<!--".length());
        this.lex.readToPattern("-->", 2);
    }

    private void parseText(StringBuffer whitespace) throws IOException, SAXException {
        String token = this.lex.readToPattern("<", 72);
        String string = whitespace == null ? token : whitespace.append(token).toString();
        char[] chars = string.toCharArray();
        this.contentHandler.characters(chars, 0, chars.length);
    }

    private void parseCData() throws IOException {
        this.lex.skip("<![CDATA[".length());
        String token = this.lex.readToPattern("]]>", 6);
        String string = token.substring(0, token.length() - "]]>".length());
    }

    private void parseXMLDecl() throws IOException {
        this.lex.skip("<?xml ".length());
        int peek = 0;
        do {
            String key = this.lex.readToken();
            this.lex.readChar(61);
            this.lex.skipWhitespace();
            int ch = this.lex.read();
            String value = null;
            if (ch == 34) {
                value = this.lex.readToPattern("\"", 66);
            } else if (ch == 39) {
                value = this.lex.readToPattern("'", 66);
            } else {
                throw new IOException("missing quote at start of attribute");
            }
            if (key.equals("version")) {
                this.version = value;
            } else if (key.equals("encoding")) {
                this.encoding = value;
            } else if (key.equals("standalone")) {
                this.standalone = value.equals("yes");
            } else {
                throw new IOException(key + " is invalid attribute for XMLDecl");
            }
            this.lex.skipWhitespace();
        } while ((peek = this.lex.peek()) != 63);
        this.lex.readChar(63);
        this.lex.readChar(62);
    }

    private void parseInstruction() throws IOException, SAXException {
        this.lex.skip("<?".length());
        String target = this.lex.readToken();
        String content = this.lex.readToPattern("?>", 3);
        this.contentHandler.processingInstruction(target, content);
    }

    private void parseDocType() throws IOException, SAXException {
        this.lex.readChar(60);
        this.lex.readToken("<!DOCTYPE".substring(1));
        String name = this.lex.readToDelimiter("[>");
        String systemId = null;
        String publicId = null;
        if (name.equals("[") || name.equals(">")) {
            throw new IOException("DOCTYPE is missing a name");
        }
        String next = this.lex.readToken();
        if (next.equals("SYSTEM")) {
            systemId = this.lex.readToDelimiter("[>", 49);
            next = this.lex.readToDelimiter("[>");
        } else if (next.equals("PUBLIC")) {
            publicId = this.lex.readToDelimiter("[>", 49);
            systemId = this.lex.readToDelimiter("[>", 49);
            next = this.lex.readToDelimiter("[>");
        }
        if (next.equals("[")) {
            block14: {
                while (true) {
                    this.lex.skipWhitespace();
                    int[] chars = new int[2];
                    this.lex.peek(chars);
                    int ch1 = chars[0];
                    int ch2 = chars[1];
                    if (ch1 == 93) break block14;
                    if (ch1 == -1) {
                        throw new IOException("could not find matching ']' in DOCTYPE");
                    }
                    if (ch1 == 37) {
                        this.lex.readToPattern(";", 6);
                        continue;
                    }
                    if (ch2 == 33 && this.lex.peekString("<!ATTLIST")) {
                        this.parseAttlistDecl();
                        continue;
                    }
                    if (ch2 == 33 && this.lex.peekString("<!ELEMENT")) {
                        this.parseElementDecl();
                        continue;
                    }
                    if (ch2 == 33 && this.lex.peekString("<!ENTITY")) {
                        this.parseEntityDecl();
                        continue;
                    }
                    if (ch2 == 33 && this.lex.peekString("<!NOTATION")) {
                        this.parseNotationDecl();
                        continue;
                    }
                    if (ch2 == 33 && this.lex.peekString("<!--")) {
                        this.parseComment();
                        continue;
                    }
                    if (ch2 != 63) break;
                    this.parseInstruction();
                }
                throw new IOException("illegal entry in DOCTYPE");
            }
            next = this.lex.readToken();
            next = this.lex.readToken();
        }
        if (!next.equals(">")) {
            throw new IOException("could not find matching '>' in DOCTYPE");
        }
    }

    private void parseAttlistDecl() throws IOException {
        this.lex.skip("<!ATTLIST".length());
        String token = this.lex.readToPattern(">", 22);
        String string = token.substring(0, token.length() - ">".length());
    }

    private void parseElementDecl() throws IOException {
        this.lex.skip("<!ELEMENT".length());
        String token = this.lex.readToPattern(">", 22);
        String string = token.substring(0, token.length() - ">".length());
    }

    private void parseEntityDecl() throws IOException {
        this.lex.skip("<!ENTITY".length());
        String token = this.lex.readToPattern(">", 22);
        String string = token.substring(0, token.length() - ">".length());
    }

    private void parseNotationDecl() throws IOException {
        this.lex.skip("<!NOTATION".length());
        String token = this.lex.readToPattern(">", 22);
        String string = token.substring(0, token.length() - ">".length());
    }

    private void parseElement(SAXScope parent) throws IOException, SAXException {
        String qName;
        SAXScope scope = new SAXScope(parent);
        this.lex.read();
        String localName = this.lex.readToken();
        String prefix = null;
        String namespace = null;
        if (this.lex.peek() == 58) {
            prefix = localName;
            this.lex.read();
            localName = this.lex.readToken();
        }
        this.lex.skipWhitespace();
        int peek = this.lex.peek();
        Attributes attributes = EMPTY_ATTRIBUTES;
        if (peek != 62 && peek != 47) {
            attributes = this.parseAttributes(scope);
        }
        if (prefix == null) {
            namespace = scope.getDefaultNamespace();
        } else {
            namespace = scope.getNamespace(prefix);
            if (namespace == null) {
                throw new SAXException("could not find namespace with prefix " + prefix);
            }
        }
        String uri = namespace == null ? "" : namespace;
        String string = qName = prefix == null ? localName : prefix + ":" + localName;
        if (scope.namespaces != null) {
            int i = 0;
            while (i < scope.namespaces.length) {
                this.contentHandler.startPrefixMapping(scope.namespaces[i][0], scope.namespaces[i][1]);
                ++i;
            }
        }
        this.contentHandler.startElement(uri, localName, qName, attributes);
        int ch = this.lex.read();
        if (ch == 47) {
            this.lex.readChar(62);
            this.contentHandler.endElement(uri, localName, qName);
        } else {
            if (ch != 62) {
                throw new IOException("expected > or /");
            }
            this.parseChildren(scope);
            this.lex.readChar(60);
            this.lex.readChar(47);
            if (prefix != null) {
                String endPrefix = this.lex.readToken();
                if (!prefix.equals(endPrefix)) {
                    throw new IOException("<" + prefix + ":...> does not match </" + endPrefix + ":...>");
                }
                this.lex.readChar(58);
            }
            String endName = this.lex.readToken();
            this.lex.readChar(62);
            if (!localName.equals(endName)) {
                throw new IOException("<..." + localName + "> does not match </..." + endName + ">");
            }
            this.contentHandler.endElement(uri, localName, qName);
            if (scope.namespaces != null) {
                int i = 0;
                while (i < scope.namespaces.length) {
                    this.contentHandler.endPrefixMapping(scope.namespaces[i][0]);
                    ++i;
                }
            }
        }
    }

    private Attributes parseAttributes(SAXScope scope) throws IOException {
        AttributesImpl attributes = new AttributesImpl();
        int peek = 0;
        do {
            String localName = this.lex.readToken();
            String prefix = null;
            if (this.lex.peek() == 58) {
                prefix = localName;
                this.lex.read();
                localName = this.lex.readToken();
            }
            this.lex.readChar(61);
            this.lex.skipWhitespace();
            int ch = this.lex.read();
            String value = null;
            String namespace = null;
            if (ch == 34) {
                value = this.lex.readToPattern("\"", 66);
            } else if (ch == 39) {
                value = this.lex.readToPattern("'", 66);
            } else {
                throw new IOException("missing quote at start of attribute");
            }
            if ("xmlns".equals(localName)) {
                namespace = "http://www.w3.org/2000/xmlns/";
                scope.setDefaultNamespace(value);
            } else if ("xmlns".equals(prefix)) {
                namespace = "http://www.w3.org/2000/xmlns/";
                scope.setNamespace(localName, value);
            } else {
                String uri = namespace == null ? "" : namespace;
                String qName = prefix == null ? localName : prefix + ":" + localName;
                attributes.addAttribute(uri, localName, qName, "CDATA", value);
            }
            this.lex.skipWhitespace();
        } while ((peek = this.lex.peek()) != 62 && peek != 47);
        return attributes;
    }

    private void parseChildren(SAXScope parent) throws IOException, SAXException {
        boolean hasChildren = false;
        while (true) {
            char[] chars;
            StringBuffer whitespace = this.lex.readWhitespace();
            this.lex.mark(2);
            int ch1 = this.lex.peekRead();
            int ch2 = this.lex.peekRead();
            this.lex.reset();
            if (ch1 == -1) break;
            if (ch1 != 60) {
                this.parseText(whitespace);
                continue;
            }
            if (ch2 == 47) {
                if (whitespace == null) break;
                chars = whitespace.toString().toCharArray();
                if (!hasChildren || !this.ignoreWhitespace) {
                    this.contentHandler.characters(chars, 0, chars.length);
                    break;
                }
                this.contentHandler.ignorableWhitespace(chars, 0, chars.length);
                break;
            }
            if (whitespace != null) {
                chars = whitespace.toString().toCharArray();
                if (this.ignoreWhitespace) {
                    this.contentHandler.ignorableWhitespace(chars, 0, chars.length);
                } else {
                    this.contentHandler.characters(chars, 0, chars.length);
                }
            }
            if (ch2 == 33 && this.lex.peekString("<![CDATA[")) {
                this.parseCData();
                continue;
            }
            if (ch2 == 33 && this.lex.peekString("<!--")) {
                this.parseComment();
                continue;
            }
            if (ch2 == 63) {
                this.parseInstruction();
                continue;
            }
            hasChildren = true;
            this.parseElement(parent);
        }
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getLineNumber() {
        return this.lex.getLineNumber();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }
}

