/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.jaxen;

import electric.xml.Attribute;
import electric.xml.Child;
import electric.xml.Children;
import electric.xml.Comment;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import electric.xml.Instruction;
import electric.xml.Node;
import electric.xml.Parent;
import electric.xml.ParseException;
import electric.xml.Text;
import electric.xml.jaxen.AttributesIterator;
import electric.xml.jaxen.ChildrenIterator;
import electric.xml.jaxen.JaxenXPath;
import electric.xml.xpath.XPathNamespace;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.XPath;
import org.jaxen.util.SingleObjectIterator;
import org.saxpath.SAXPathException;

public class DocumentNavigator
extends DefaultNavigator
implements IXMLConstants {
    private static DocumentNavigator documentNavigator = new DocumentNavigator();

    public static DocumentNavigator getInstance() {
        return documentNavigator;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new JaxenXPath(xpath);
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof Instruction;
    }

    public String getProcessingInstructionTarget(Object object) {
        return ((Instruction)object).getTarget();
    }

    public String getProcessingInstructionData(Object object) {
        return ((Instruction)object).getContent();
    }

    public boolean isComment(Object object) {
        return object instanceof Comment;
    }

    public String getCommentStringValue(Object object) {
        return ((Comment)object).getString();
    }

    public boolean isText(Object object) {
        return object instanceof Text;
    }

    public String getTextStringValue(Object object) {
        return ((Text)object).getString();
    }

    public boolean isElement(Object object) {
        return object instanceof Element;
    }

    public String getElementName(Object object) {
        return ((Element)object).getLocalName();
    }

    public String getElementNamespaceUri(Object object) {
        return ((Node)object).getNamespaceURI();
    }

    public String getElementQName(Object object) {
        return ((Element)object).getNodeName();
    }

    public String getElementStringValue(Object object) {
        return this.getStringValue((Element)object);
    }

    private String getStringValue(Element element) {
        StringBuffer buf = new StringBuffer();
        Children children = element.getChildren();
        Child eachChild = null;
        while ((eachChild = children.next()) != null) {
            if (eachChild instanceof Element) {
                buf.append(this.getStringValue((Element)eachChild));
                continue;
            }
            if (!(eachChild instanceof Text)) continue;
            buf.append(((Text)eachChild).getString());
        }
        return buf.toString();
    }

    public boolean isAttribute(Object object) {
        return object instanceof Attribute;
    }

    public String getAttributeQName(Object object) {
        return ((Attribute)object).getNodeName();
    }

    public String getAttributeStringValue(Object object) {
        return ((Attribute)object).getValue();
    }

    public String getAttributeName(Object object) {
        return ((Attribute)object).getLocalName();
    }

    public String getAttributeNamespaceUri(Object object) {
        return ((Attribute)object).getNamespace();
    }

    public boolean isDocument(Object object) {
        return object instanceof Document;
    }

    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof Document) {
            return contextNode;
        }
        return ((Element)contextNode).getDocument();
    }

    public Object getDocument(String url) throws FunctionCallException {
        try {
            return new Document(new File(url));
        }
        catch (ParseException exception) {
            throw new FunctionCallException(exception.getMessage());
        }
    }

    public boolean isNamespace(Object object) {
        return object instanceof XPathNamespace;
    }

    public String getNamespacePrefix(Object object) {
        return ((XPathNamespace)object).getPrefix();
    }

    public String getNamespaceStringValue(Object object) {
        return ((XPathNamespace)object).getNamespaceURI();
    }

    public String translateNamespacePrefixToUri(String prefix, Object context) {
        if (context instanceof Element) {
            return ((Element)context).getNamespace(prefix);
        }
        return null;
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        if (contextNode instanceof Parent) {
            return new ChildrenIterator(((Parent)contextNode).getChildren());
        }
        return null;
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) {
        if (!(contextNode instanceof Element)) {
            return null;
        }
        Element elem = (Element)contextNode;
        HashMap<String, XPathNamespace> nsMap = new HashMap<String, XPathNamespace>();
        Element current = elem;
        while (current != null) {
            Parent parent;
            Dictionary namespaces = current.getNamespaces();
            if (namespaces != null) {
                Enumeration keys = namespaces.keys();
                while (keys.hasMoreElements()) {
                    String prefix = (String)keys.nextElement();
                    if (nsMap.containsKey(prefix)) continue;
                    String uri = (String)namespaces.get(prefix);
                    nsMap.put(prefix, new XPathNamespace(elem, prefix, uri));
                }
            }
            if (!((parent = current.getParent()) instanceof Element)) break;
            current = (Element)parent;
        }
        XPathNamespace xml = new XPathNamespace(elem, "xml", "http://www.w3.org/XML/1998/namespace");
        nsMap.put("xml", xml);
        return nsMap.values().iterator();
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        Object parent = null;
        if (contextNode instanceof Document) {
            parent = contextNode;
        } else if (contextNode instanceof Element) {
            parent = ((Element)contextNode).getParent();
            if (parent == null) {
                parent = ((Element)contextNode).getDocument();
            }
        } else if (contextNode instanceof Attribute) {
            parent = ((Attribute)contextNode).getElement();
        } else if (contextNode instanceof Instruction) {
            parent = ((Instruction)contextNode).getParent();
        } else if (contextNode instanceof Text) {
            parent = ((Text)contextNode).getParent();
        } else if (contextNode instanceof Comment) {
            parent = ((Text)contextNode).getParent();
        } else if (contextNode instanceof XPathNamespace) {
            parent = ((XPathNamespace)contextNode).getOwnerElement();
        }
        if (parent != null) {
            return new SingleObjectIterator(parent);
        }
        return null;
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (!(contextNode instanceof Element)) {
            return null;
        }
        Element elem = (Element)contextNode;
        return new AttributesIterator(elem.getAttributeObjects());
    }
}

