/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.tools;

import electric.util.classloader.ClassLoaders;
import electric.util.command.Commands;
import electric.util.file.FileUtil;
import electric.util.jar.Jar;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Java2Schema
implements ILoaderConstants,
ISchemaConstants {
    private Vector classNames = new Vector();
    private String dir = "";
    private String outputPath = "";
    private String encodingStyle = null;
    private boolean readMapFiles = false;

    public static void main(String[] args) {
        if (args.length == 0) {
            Java2Schema.printUsage();
            return;
        }
        try {
            Java2Schema java2schema = Java2Schema.processArgs(args);
            java2schema.java2schema();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Java2Schema.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: java2schema [-Dname=value]* [-h] classname+ [-d directory] [-i path] [-o dir/jar] [-x cmdfile]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value     = set java system property");
        System.out.println("  classname        = name of java class");
        System.out.println("  -d directory     = output path for schema files, '.' by default");
        System.out.println("  -e encodingStyle = the encodingStyle to use for the schema");
        System.out.println("  -h               = print help and exit");
        System.out.println("  -i path          = input path for map files, '.' by default");
        System.out.println("  -o dir/jar       = output path for map files, '.' by default");
        System.out.println("  -x cmdfile       = command file to execute");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("java2schema examples.publish.Exchange");
        System.out.println("  creates schema and map files for examples.publish.Exchange");
    }

    private static Java2Schema processArgs(String[] args) throws Throwable {
        Mappings.clear();
        Java2Schema java2schema = new Java2Schema();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                java2schema.classNames.addElement(arg);
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'd': {
                        java2schema.dir = Strings.getString("d", args, ++i);
                        if (java2schema.dir.endsWith("/") || java2schema.dir.endsWith("\\")) break;
                        java2schema.dir = java2schema.dir + File.separator;
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'e': {
                        java2schema.encodingStyle = Strings.getString("e", args, ++i);
                        break;
                    }
                    case 'h': {
                        Java2Schema.printUsage();
                        System.exit(-1);
                    }
                    case 'i': {
                        String mapPath = Strings.getString("i", args, ++i);
                        Mappings.readMappings(mapPath);
                        java2schema.readMapFiles = true;
                        break;
                    }
                    case 'o': {
                        java2schema.outputPath = Strings.getString("o", args, ++i);
                        break;
                    }
                    case 'x': {
                        String commandFile = Strings.getString("x", args, ++i);
                        Commands.execute(commandFile);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        return java2schema;
    }

    private void java2schema() throws IOException, ClassNotFoundException, ParseException {
        if (!this.readMapFiles) {
            Mappings.readMappings();
        }
        if (this.classNames.isEmpty()) {
            throw new IllegalArgumentException("missing class names");
        }
        this.writeSchemasAndMap();
    }

    private void writeSchemasAndMap() throws IOException, ClassNotFoundException {
        Hashtable closure = this.getClosure();
        this.writeSchemas(closure);
        this.writeMappings(closure);
    }

    private Hashtable getClosure() throws ClassNotFoundException, SchemaException {
        Namespaces namespaces = new Namespaces(SchemaProperties.getDefaultSchema(), this.encodingStyle);
        Hashtable closure = new Hashtable();
        Enumeration enumeration = this.classNames.elements();
        while (enumeration.hasMoreElements()) {
            String javaName = (String)enumeration.nextElement();
            Class javaClass = ClassLoaders.loadClass(javaName);
            Type type = namespaces.getTypeWithJavaClass(javaClass);
            type.addAllDependencies(closure);
        }
        return closure;
    }

    private void writeSchemas(Hashtable closure) throws ClassNotFoundException, IOException {
        Enumeration enumeration = closure.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            if (type.isStandard()) continue;
            if (type instanceof ArrayType) {
                this.writeSchema(type.getName(), type);
                continue;
            }
            Class javaClass = type.getJavaClassWithCheck();
            String filename = Strings.getLocalJavaName(javaClass.getName());
            this.writeSchema(filename, type);
        }
    }

    private void writeSchema(String filename, Type type) throws IOException {
        Document schema = Java2Schema.getSchema(type);
        FileUtil.saveFile(this.dir, filename, schema.toString(), ".xsd");
    }

    private static Document getSchema(Type type) throws SchemaException {
        Document document = new Document();
        document.addComment(Java2Schema.getDescription());
        Element schema = document.newRoot();
        schema.setNamespace("xsd", type.getNamespaces().getVersion());
        if (!type.getNamespace().equals("")) {
            schema.setAttribute("targetNamespace", type.getNamespace());
        }
        schema.setName("xsd", "schema");
        type.appendSchema(schema, false);
        return document;
    }

    private void writeMappings(Hashtable closure) throws IOException {
        Document mappings = Java2Schema.getMappings(closure);
        this.writeMappings(mappings);
    }

    private static Document getMappings(Hashtable closure) throws SchemaException {
        Document mappings = new Document();
        mappings.addComment(Java2Schema.getDescription());
        Element root = mappings.newRoot();
        root.setNamespace("map", SchemaProperties.getTmeMap());
        root.setName("map", "mappings");
        Enumeration enumeration = closure.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            if (type.isStandard() || type.isInhibit() || type.getName() == null) continue;
            type.appendSchema(root, true);
        }
        return mappings;
    }

    private void writeMappings(Document mappings) throws IOException {
        String firstName = (String)this.classNames.elementAt(0);
        String filename = Strings.getLocalJavaName(firstName);
        String content = mappings.toString();
        if (this.outputPath.endsWith(".jar")) {
            Jar.saveFile(this.outputPath, filename + ".map", content);
        } else {
            if (this.outputPath.length() > 0 && !this.outputPath.endsWith(ILoaderConstants.FILE_SEPARATOR)) {
                this.outputPath = this.outputPath + ILoaderConstants.FILE_SEPARATOR;
            }
            FileUtil.saveFile(this.outputPath, filename, content, ".map");
        }
    }

    private static String getDescription() {
        return "generated by " + Product.getShortDescription() + " (java2schema) on " + new Date();
    }
}

