/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.schema;

import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.log.Log;
import electric.util.resourceloader.ResourceLoaders;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.ParseException;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.model.Group;
import electric.xml.io.schema.EncodingMismatchException;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.File;
import java.io.IOException;

public final class Schema
implements ISchemaConstants,
IEXMLLoggingConstants {
    private Namespaces namespaces;
    private String version;
    private String targetNamespace;
    private boolean qualifyElements;
    private boolean qualifyAttributes;
    private SchemaEntry[] schemaEntrys = new SchemaEntry[0];
    private Type[] schemaTypes = new Type[0];

    public Schema(String namespace) {
        this(namespace, SchemaProperties.getDefaultSchema(), false, false);
    }

    public Schema(String namespace, String version) {
        this(namespace, version, false, false);
    }

    public Schema(String namespace, String version, boolean qualifyElements, boolean qualifyAttributes) {
        this.targetNamespace = namespace;
        this.version = version;
        this.qualifyElements = qualifyElements;
        this.qualifyAttributes = qualifyAttributes;
    }

    public Schema(Namespaces namespaces, String namespace, String version, boolean qualifyElements, boolean qualifyAttributes) {
        this(namespace, version, qualifyElements, qualifyAttributes);
        this.namespaces = namespaces;
        namespaces.cacheSchema(this);
    }

    public Schema(Element schema) throws SchemaException {
        this(new Namespaces(schema.getNamespace()), schema);
    }

    public Schema(Namespaces namespaces, Element schema) throws SchemaException {
        String elementFormDefault;
        this.version = schema.getNamespace();
        this.targetNamespace = schema.getAttributeValue("targetNamespace");
        if (this.targetNamespace == null) {
            this.targetNamespace = "";
        }
        this.qualifyElements = (elementFormDefault = schema.getAttributeValue("elementFormDefault")) != null && elementFormDefault.equalsIgnoreCase("qualified");
        String attributeFormDefault = schema.getAttributeValue("attributeFormDefault");
        this.qualifyAttributes = attributeFormDefault != null && attributeFormDefault.equalsIgnoreCase("qualified");
        this.namespaces = namespaces;
        namespaces.cacheSchema(this);
        this.parseSchema(schema);
    }

    public void parseSchema(Element schema) throws SchemaException {
        this.parseImports(schema);
        this.parseIncludes(schema);
        this.parseGroups(schema);
        this.parseAttributes(schema);
        this.parseElements(schema);
        this.parseComplexTypes(schema);
        this.parseSimpleTypes(schema);
        if (schema.hasElement("redefine") && Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
            Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, (Object)"redefines are currently not supported");
        }
        if (schema.hasElement("attributeGroup") && Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
            Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, (Object)"attributeGroups are currently not supported");
        }
        if (schema.hasElement("notation") && Log.isLogging(IEXMLLoggingConstants.SCHEMA_EVENT)) {
            Log.log(IEXMLLoggingConstants.SCHEMA_EVENT, (Object)"notations are currently not supported");
        }
    }

    private void parseIncludes(Element schema) throws SchemaException {
        Elements includedSchemas = schema.getElements("include");
        while (includedSchemas.hasMoreElements()) {
            Element included = includedSchemas.next();
            String location = included.getAttribute("schemaLocation");
            String namespace = included.getAttribute("namespace");
            if (namespace != null && namespace.equals("http://schemas.xmlsoap.org/soap/encoding/") || ArrayUtil.contains(namespace, SchemaProperties.getXSDS()) || location == null) continue;
            if (Log.isLogging("MAPPING")) {
                Log.log("MAPPING", (Object)("Parsing included schema " + location));
            }
            Document schemaDoc = null;
            try {
                try {
                    schemaDoc = new XURL(location).getProtocol() == null ? new Document(new File(location)) : new Document(ResourceLoaders.loadResource(location));
                }
                catch (IOException exception) {
                    throw new SchemaException("Could not load schema from " + location);
                }
                Element includedSchema = schemaDoc.getRoot();
                if (includedSchema.hasAttribute("targetNamespace") && !this.getTargetNamespace().equals(includedSchema.getAttribute("targetNamespace"))) {
                    throw new SchemaException("Included schema has a different targetNamespace than surrounding schema. " + location);
                }
                this.parseSchema(includedSchema);
            }
            catch (ParseException exception) {
                throw new SchemaException("unable to parse included schema document - " + exception.toString());
            }
        }
    }

    private void parseImports(Element schema) throws SchemaException {
        Elements includedSchemas = schema.getElements("import");
        while (includedSchemas.hasMoreElements()) {
            Schema cachedSchema;
            Document schemaDoc;
            Element included = includedSchemas.next();
            String location = included.getAttribute("schemaLocation");
            String namespace = included.getAttribute("namespace");
            if (namespace != null && namespace.equals("http://schemas.xmlsoap.org/soap/envelope/") || namespace != null && namespace.equals("http://schemas.xmlsoap.org/soap/encoding/") || ArrayUtil.contains(namespace, SchemaProperties.getXSDS()) || location == null) continue;
            if (Log.isLogging("MAPPING")) {
                Log.log("MAPPING", (Object)("Parsing imported schema " + location));
            }
            try {
                schemaDoc = new XURL(location).getProtocol() == null ? new Document(new File(location)) : new Document(ResourceLoaders.loadResource(location));
            }
            catch (ParseException exception) {
                throw new SchemaException("unable to parse imported schema document - " + exception.toString());
            }
            catch (IOException exception) {
                throw new SchemaException("unable to parse imported schema document - " + exception.toString());
            }
            String tns = schemaDoc.getRoot().getAttribute("targetNamespace");
            if (tns == null) {
                tns = "";
            }
            if ((cachedSchema = this.namespaces.getSchema(tns)) == null) {
                new Schema(this.namespaces, schemaDoc.getRoot());
                continue;
            }
            cachedSchema.parseSchema(schemaDoc.getRoot());
        }
    }

    private void parseElements(Element schema) throws SchemaException {
        Elements elements = schema.getElements("element");
        while (elements.hasMoreElements()) {
            this.addSchemaEntry(new SchemaElement(this, elements.next()));
        }
    }

    private void parseAttributes(Element schema) throws SchemaException {
        Elements elements = schema.getElements("attribute");
        while (elements.hasMoreElements()) {
            this.addSchemaEntry(new SchemaAttribute(this, elements.next()));
        }
    }

    private void parseComplexTypes(Element schema) throws SchemaException {
        Elements complexTypes = schema.getElements("complexType");
        while (complexTypes.hasMoreElements()) {
            try {
                Element complexType = complexTypes.next();
                String name = complexType.getAttributeValue("name");
                Type type = this.namespaces.getTypeWithSchema(this.targetNamespace, name, complexType);
                if (ArrayUtil.contains(type, this.schemaTypes)) continue;
                this.addSchemaType(type);
            }
            catch (EncodingMismatchException exception) {
                if (Mappings.isMappingNamespaces(this.namespaces)) continue;
                throw exception;
            }
        }
    }

    private void parseGroups(Element schema) throws SchemaException {
        Elements groups = schema.getElements("group");
        while (groups.hasMoreElements()) {
            Element groupElement = groups.next();
            Group group = new Group(this, groupElement);
            this.addSchemaEntry(group);
        }
    }

    private void parseSimpleTypes(Element schema) throws SchemaException {
        Elements simpleTypes = schema.getElements("simpleType");
        while (simpleTypes.hasMoreElements()) {
            Element simpleType = simpleTypes.next();
            String name = simpleType.getAttributeValue("name");
            Type typeWithSchema = this.namespaces.getTypeWithSchema(this.targetNamespace, name, simpleType);
            if (ArrayUtil.contains(typeWithSchema, this.schemaTypes)) continue;
            this.addSchemaType(typeWithSchema);
        }
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Namespaces namespaces) {
        if (this.namespaces == namespaces) {
            return;
        }
        this.namespaces = namespaces;
        int i = 0;
        while (i < this.schemaEntrys.length) {
            namespaces.addItem(this.schemaEntrys[i]);
            ++i;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean getQualifyElements() {
        return this.qualifyElements;
    }

    public void setQualifyElements(boolean qualify) {
        this.qualifyElements = qualify;
    }

    public boolean getQualifyAttributes() {
        return this.qualifyAttributes;
    }

    public void setQualifyAttributes(boolean qualify) {
        this.qualifyAttributes = qualify;
    }

    public SchemaEntry[] getSchemaEntrys() {
        return this.schemaEntrys;
    }

    private void addSchemaEntry(SchemaEntry schemaEntry) {
        this.schemaEntrys = (SchemaEntry[])ArrayUtil.addElement(this.schemaEntrys, schemaEntry);
        this.namespaces.addItem(schemaEntry);
    }

    public Type getType(String name) {
        int i = 0;
        while (i < this.schemaTypes.length) {
            String typeName = this.schemaTypes[i].getName();
            if (typeName != null && typeName.equals(name)) {
                return this.schemaTypes[i];
            }
            ++i;
        }
        return null;
    }

    public Type[] getSchemaTypes() {
        return this.schemaTypes;
    }

    public void addSchemaType(Type type) {
        this.schemaTypes = (Type[])ArrayUtil.addElement(this.schemaTypes, type);
    }

    public void removeSchemaType(Type type) {
        this.schemaTypes = (Type[])ArrayUtil.removeElementIdentity(this.schemaTypes, type);
    }
}

