/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.model;

import electric.util.Value;
import electric.util.java.JavaSource;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.model.All;
import electric.xml.io.model.Choice;
import electric.xml.io.model.IModel;
import electric.xml.io.model.Sequence;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;

public class Group
extends SchemaEntry
implements IModel {
    private IModel childType;
    static /* synthetic */ Class class$electric$xml$io$model$Group;

    public Group(Type parentType, Element schemaElement) throws SchemaException {
        super(parentType);
        this.readSchema(schemaElement);
    }

    public Group(Schema schema, Element schemaElement) throws SchemaException {
        super(schema);
        this.readSchema(schemaElement);
    }

    public void readSchema(Element schemaElement) throws SchemaException {
        this.setName(schemaElement.getAttribute("name"));
        this.refQName = schemaElement.getAttributeValue("ref");
        if (this.refQName != null) {
            this.refQName = schemaElement.getQName(this.refQName);
            return;
        }
        Elements elements = schemaElement.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (this.parentType != null) {
                if (child.getName().equals("sequence")) {
                    this.childType = new Sequence(this.parentType, child);
                    continue;
                }
                if (child.getName().equals("all")) {
                    this.childType = new All(this.parentType, child);
                    continue;
                }
                if (child.getName().equals("choice")) {
                    this.childType = new Choice(this.parentType, child);
                    continue;
                }
                if (child.getName().equals("annotation")) continue;
                throw new SchemaException("<group> in type " + this.parentType.getQName() + " must currently be followed by <sequence>, <all>, <choice>, or <annotation>");
            }
            if (child.getName().equals("sequence")) {
                this.childType = new Sequence(this.schema, child);
                continue;
            }
            if (child.getName().equals("all")) {
                this.childType = new All(this.schema, child);
                continue;
            }
            if (child.getName().equals("choice")) {
                this.childType = new Choice(this.schema, child);
                continue;
            }
            if (child.getName().equals("annotation")) continue;
            throw new SchemaException("<group> must currently be followed by <sequence>, <all>, <choice>, or <annotation>");
        }
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = element.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
        Element group = element.addElement(xsdPrefix, "group");
        this.getChildType().writeSchema(group, annotated);
    }

    public String getJavaName() throws SchemaException {
        return this.parentType.getJavaName();
    }

    public Class getJavaClass() throws SchemaException {
        return this.parentType.getJavaClass();
    }

    public void writeJava(JavaSource source) throws SchemaException {
        this.getChildType().writeJava(source);
    }

    public void forceResolution() {
        try {
            this.getChildType().forceResolution();
        }
        catch (SchemaException exception) {}
    }

    public IModel getChildType() throws SchemaException {
        if (this.childType != null) {
            return this.childType;
        }
        if (this.refQName != null) {
            Group entry = (Group)this.schema.getNamespaces().getItem(this.refQName, class$electric$xml$io$model$Group == null ? (class$electric$xml$io$model$Group = Group.class$("electric.xml.io.model.Group")) : class$electric$xml$io$model$Group);
            this.childType = entry.getChildType();
            this.name = entry.getName();
            if (this.minOccurs == 1) {
                this.minOccurs = entry.minOccurs;
            }
            if (this.maxOccurs == 1) {
                this.maxOccurs = entry.maxOccurs;
            }
            return this.childType;
        }
        throw new SchemaException("group " + this.schema.getTargetNamespace() + ":" + this.name + " has no child model group");
    }

    public SchemaElement getSchemaElement(String name) throws SchemaException {
        return this.getChildType().getSchemaElement(name);
    }

    public SchemaAttribute getSchemaAttribute(String name) throws SchemaException {
        return this.getChildType().getSchemaAttribute(name);
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        this.getChildType().writeObject(writer, object);
    }

    public void readObject(IReader reader, Value value) throws IOException {
        this.getChildType().readObject(reader, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

