/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.mapping;

import electric.util.log.Log;
import electric.util.resourceloader.ResourceLoaders;
import electric.xml.Document;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.ParseException;
import electric.xml.io.mapping.ILoader;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.mapping.MapFile;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class FileLoader
implements ILoader,
ILoaderConstants,
IEXMLLoggingConstants {
    public MapFile[] loadMapFiles(String path) throws IOException, ParseException {
        if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
            Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("load map file " + path));
        }
        try {
            byte[] bytes = ResourceLoaders.loadResource(path);
            return new MapFile[]{new MapFile(path, new Document(bytes))};
        }
        catch (FileNotFoundException exception) {
            if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("unable to locate mappath resource " + path));
            }
            return null;
        }
    }
}

