/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.mapping;

import electric.util.array.ArrayUtil;
import electric.util.log.Log;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.ParseException;
import electric.xml.io.mapping.FileLoader;
import electric.xml.io.mapping.ILoader;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.mapping.MapFile;
import java.io.File;
import java.io.IOException;

public final class DirectoryLoader
implements ILoader,
ILoaderConstants,
IEXMLLoggingConstants {
    private static final FileLoader fileLoader = new FileLoader();

    public MapFile[] loadMapFiles(String path) throws IOException, ParseException {
        File file = new File(path);
        return file.exists() && file.isDirectory() ? this.loadMapFiles(file) : ILoaderConstants.NO_MAP_FILES;
    }

    private MapFile[] loadMapFiles(File directory) throws IOException, ParseException {
        String dirName = directory.getPath();
        String[] filenames = directory.list();
        MapFile[] mapFiles = new MapFile[]{};
        int i = 0;
        while (i < filenames.length) {
            if (filenames[i].endsWith(".map")) {
                String path = dirName + File.separator + filenames[i];
                MapFile[] array = fileLoader.loadMapFiles(path);
                if (array == null) {
                    if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                        Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("no mappings could be loaded from path " + path));
                    }
                } else {
                    mapFiles = (MapFile[])ArrayUtil.addElements(mapFiles, array);
                }
            }
            ++i;
        }
        return mapFiles;
    }
}

