/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.collections.sun;

import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.Vector;

public abstract class CollectionType
extends Type {
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    protected Type objectArrayType;

    public CollectionType() {
        this.setInhibit(true);
    }

    private Type getObjectArrayType() {
        if (this.objectArrayType != null) {
            return this.objectArrayType;
        }
        try {
            this.objectArrayType = this.getType(OBJECT_ARRAY_CLASS);
        }
        catch (SchemaException exception) {}
        return this.objectArrayType;
    }

    public void addDependencies(Vector dependencies) {
        try {
            dependencies.addElement(this.getType(OBJECT_ARRAY_CLASS));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeArray(IWriter writer, String name, Object[] array) throws IOException {
        writer.writeObject(name, array, this.getObjectArrayType());
    }

    public Object[] readArray(IReader reader, String name) throws IOException {
        IReader arrayReader = reader.getReader(name);
        return arrayReader == null ? NO_OBJECTS : (Object[])arrayReader.readObject(this.getObjectArrayType());
    }
}

