/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.accessors;

import electric.util.Value;
import electric.util.classloader.ClassLoaders;
import electric.util.java.JavaField;
import electric.util.java.JavaSource;
import electric.util.reflect.Accessibility;
import electric.util.reflect.MethodLookup;
import electric.xml.Element;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class MethodAccessor
extends Accessor {
    private String getName;
    private String setName;
    private Object NO_CLASSLOADER = new Object();
    private Hashtable classLoaderToMethod = new Hashtable();

    public MethodAccessor(IAccessible accessible, String getName, String setName) {
        super(accessible);
        this.getName = getName;
        this.setName = setName;
    }

    public String toString() {
        return "MethodAccessor( " + this.getName + ", " + this.setName + " )";
    }

    public void set(Value target, Value value) throws Exception {
        this.getSetMethod().invoke(target.object, value.object);
    }

    private synchronized Method getSetMethod() throws SchemaException, NoSuchMethodException {
        Method[] returnMethod;
        Object key = ClassLoaders.getContextClassLoader();
        if (key == null) {
            key = this.NO_CLASSLOADER;
        }
        if ((returnMethod = (Method[])this.classLoaderToMethod.get(key)) == null) {
            returnMethod = this.getMethods();
            this.classLoaderToMethod.put(key, returnMethod);
        }
        return returnMethod[1];
    }

    public Object get(Object target) throws Exception {
        return this.getGetMethod().invoke(target, null);
    }

    private synchronized Method getGetMethod() throws SchemaException, NoSuchMethodException {
        Method[] returnMethod;
        Object key = ClassLoaders.getContextClassLoader();
        if (key == null) {
            key = this.NO_CLASSLOADER;
        }
        if ((returnMethod = (Method[])this.classLoaderToMethod.get(key)) == null) {
            returnMethod = this.getMethods();
            this.classLoaderToMethod.put(key, returnMethod);
        }
        return returnMethod[0];
    }

    private Method[] getMethods() throws SchemaException, NoSuchMethodException {
        Method getMethod = this.getGetMethod0();
        Method setMethod = this.setName == null ? null : this.getSetMethod0();
        Method[] returnMethod = new Method[]{getMethod, setMethod};
        return returnMethod;
    }

    private synchronized Method getSetMethod0() throws SchemaException, NoSuchMethodException {
        Method setMethod = MethodLookup.getMethod(this.accessible.getAccessibleJavaClass(), this.setName, 1);
        if (Accessibility.canSetAccessible()) {
            Accessibility.setAccessible(new Method[]{setMethod}, true);
        }
        return setMethod;
    }

    private synchronized Method getGetMethod0() throws SchemaException, NoSuchMethodException {
        Method getMethod = MethodLookup.getMethod(this.accessible.getAccessibleJavaClass(), this.getName, 0);
        if (Accessibility.canSetAccessible()) {
            Accessibility.setAccessible(new Method[]{getMethod}, true);
        }
        return getMethod;
    }

    public void annotateSchema(Element element) {
        element.setAttribute("map", "get", this.getName);
        if (this.setName != null) {
            element.setAttribute("map", "set", this.setName);
        }
    }

    public void writeJava(JavaSource source) throws SchemaException {
        String javaName = this.getJavaName();
        source.addField(new JavaField("private", javaName, this.getName, null));
        StringBuffer buffer = new StringBuffer();
        buffer.append("  public " + javaName + " " + this.getName + "()\n");
        buffer.append("    {\n");
        buffer.append("    return " + this.getName + ";\n");
        buffer.append("    }");
        source.addMethod(buffer.toString());
        if (this.setName != null) {
            buffer = new StringBuffer();
            buffer.append("  public void " + this.setName + "( " + javaName + " value )\n");
            buffer.append("    {\n");
            buffer.append("    this." + this.getName + " = value;\n");
            buffer.append("    }");
            source.addMethod(buffer.toString());
        }
    }
}

