/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.Child;
import electric.xml.Children;
import electric.xml.Comment;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ElementsFilter;
import electric.xml.Fragment;
import electric.xml.IXPath;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.Selection;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Parent
extends Child {
    protected NodeList children = new NodeList();

    public Parent() {
    }

    public Parent(Parent parent) {
        Node node = parent.children.first;
        while (node != null) {
            this.addChild((Child)((Child)node).clone());
            node = node.next;
        }
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Children getChildren() {
        return new Children(this.children);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public Child addChild(Child child) {
        child.setParent(this);
        this.children.append(child);
        return child;
    }

    public Child insertChild(Child child) {
        child.setParent(this);
        this.children.insert(child);
        return child;
    }

    void replaceChild(Child oldChild, Child newChild) {
        this.children.replace(oldChild, newChild);
        newChild.setParent(this);
    }

    public String getNamespace(String prefix) {
        return null;
    }

    protected void addNamespacePrefixes(String namespace, Vector prefixes, Vector matches) {
    }

    public String getNamespacePrefix(String namespace) {
        return null;
    }

    public void addComment(String text) {
        this.addChild(new Comment(text));
    }

    public void insertComment(String text) {
        this.insertChild(new Comment(text));
    }

    public boolean hasElements() {
        return this.getElements().current() != null;
    }

    public Elements getElements() {
        return new ElementsFilter(this.children);
    }

    public Element getElement(String name) {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element && ((Element)node).name.equals(name)) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element getElement(String namespace, String name) {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element && ((Element)node).hasName(namespace, name)) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element getElement(IXPath xpath) {
        return xpath.getElement(this);
    }

    public boolean hasElement(String name) {
        return this.getElement(name) != null;
    }

    public Element getElementAt(int index) throws IndexOutOfBoundsException {
        int n = 0;
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element && ++n == index) {
                return (Element)node;
            }
            node = node.next;
        }
        throw new IndexOutOfBoundsException(index + " is an invalid index");
    }

    public Element getFirstElement() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element setElementAt(int index, Element element) throws IndexOutOfBoundsException {
        Element previous = this.getElementAt(index);
        previous.replaceWith(element);
        return previous;
    }

    public Element setElement(String name) {
        Element element = this.getElement(name);
        if (element == null) {
            element = this.addElement(name);
        }
        return element;
    }

    public Element setElement(String prefix, String name) {
        Element element = this.getElement(prefix, name);
        if (element == null) {
            element = this.addElement(prefix, name);
        }
        return element;
    }

    public Element removeElementAt(int index) {
        Element element = this.getElementAt(index);
        element.remove();
        return element;
    }

    public Elements getElements(String name) {
        NodeList selected = new NodeList();
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element && ((Element)node).name.equals(name)) {
                selected.append(new Selection(node));
            }
            node = node.next;
        }
        return new Elements(selected);
    }

    public Elements getElements(String namespace, String name) {
        NodeList selected = new NodeList();
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element && ((Element)node).hasName(namespace, name)) {
                selected.append(new Selection(node));
            }
            node = node.next;
        }
        return new Elements(selected);
    }

    public Elements getElements(IXPath xpath) {
        return xpath.getElements(this);
    }

    public Element addElement(Element element) {
        this.addChild(element);
        return element;
    }

    public Element addElement() {
        return this.addElement(new Element());
    }

    public Element addElement(String name) {
        return this.addElement().setName(name);
    }

    public Element addElement(String prefix, String name) {
        return this.addElement().setName(prefix, name);
    }

    public Element insertElement(Element element) {
        this.insertChild(element);
        return element;
    }

    public Element insertElement() {
        return this.insertElement(new Element());
    }

    public Element insertElement(String name) {
        return this.insertElement().setName(name);
    }

    public Element insertElement(String prefix, String name) {
        return this.insertElement().setName(prefix, name);
    }

    public void removeElements() {
        this.getElements().remove();
    }

    public Element removeElement(String name) {
        Element element = this.getElement(name);
        if (element != null) {
            element.remove();
        }
        return element;
    }

    public Element removeElement(String namespace, String name) {
        Element element = this.getElement(namespace, name);
        if (element != null) {
            element.remove();
        }
        return element;
    }

    public Element removeElement(IXPath xpath) {
        Element element = this.getElement(xpath);
        if (element != null) {
            element.remove();
        }
        return element;
    }

    public Elements removeElements(String name) {
        Elements elements = this.getElements(name);
        elements.remove();
        elements.reset();
        return elements;
    }

    public Elements removeElements(String namespace, String name) {
        Elements elements = this.getElements(namespace, name);
        elements.remove();
        elements.reset();
        return elements;
    }

    public Elements removeElements(IXPath xpath) {
        Elements elements = this.getElements(xpath);
        elements.remove();
        elements.reset();
        return elements;
    }

    protected Element needElement(String name) throws NumberFormatException {
        Element child = this.getElement(name);
        if (child != null) {
            return child;
        }
        throw new NumberFormatException("could not find element with name " + name);
    }

    protected Element needElement(String namespace, String name) throws NumberFormatException {
        Element child = this.getElement(namespace, name);
        if (child != null) {
            return child;
        }
        throw new NumberFormatException("could not find element with name " + name);
    }

    public synchronized Element getElementWithId(String value) {
        Node node = this.children.first;
        while (node != null) {
            Element element;
            if (node instanceof Element && (element = ((Element)node).getElementWithId(value)) != null) {
                return element;
            }
            node = node.next;
        }
        return null;
    }

    synchronized void addIds(Hashtable idToElement) {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element) {
                ((Element)node).addIds(idToElement);
            }
            node = node.next;
        }
    }

    public int size() {
        int size = 0;
        Node node = this.children.first;
        while (node != null) {
            size += node.size();
            node = node.next;
        }
        return size;
    }

    public boolean hasChildNodes() {
        return this.hasChildren();
    }

    public org.w3c.dom.NodeList getChildNodes() {
        return this.children;
    }

    public org.w3c.dom.Node getFirstChild() {
        return this.children.first;
    }

    public org.w3c.dom.Node getLastChild() {
        return this.children.last;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) {
        if (newChild instanceof Fragment) {
            Children children = ((Fragment)newChild).getChildren();
            while (children.hasMoreElements()) {
                this.appendChild(children.next());
            }
        } else {
            this.addChild((Child)newChild);
        }
        return newChild;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) {
        if (oldChild instanceof Fragment) {
            Children children = ((Fragment)oldChild).getChildren();
            while (children.hasMoreElements()) {
                this.removeChild(children.next());
            }
        } else {
            ((Node)oldChild).remove();
        }
        return oldChild;
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) {
        if (newChild instanceof Fragment) {
            Children children = ((Fragment)newChild).getChildren();
            while (children.hasMoreElements()) {
                this.insertBefore(children.next(), refChild);
            }
        } else if (refChild == null) {
            this.appendChild(newChild);
        } else {
            this.children.insertSiblingNode((Child)refChild, (Child)newChild);
            ((Child)newChild).setParent(this);
        }
        return newChild;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) {
        this.replaceChild((Child)oldChild, (Child)newChild);
        return oldChild;
    }
}

