/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.store.memory;

import electric.util.time.TimeUtil;
import electric.xdb.store.memory.MemoryStore;

final class DataReaper
implements Runnable {
    private MemoryStore store;
    private boolean reaping;
    private Thread thread;

    DataReaper(MemoryStore store) {
        this.store = store;
    }

    public void setReaping(boolean flag) {
        if (flag && !this.reaping) {
            this.reaping = true;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        } else if (this.reaping && !flag) {
            this.reaping = false;
            this.thread.interrupt();
        }
    }

    public boolean isReaping() {
        return this.reaping;
    }

    public void update() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.reaping) {
            long nextDieAt = this.store.reap();
            try {
                if (nextDieAt == -1L) {
                    DataReaper dataReaper = this;
                    synchronized (dataReaper) {
                        this.wait();
                        continue;
                    }
                }
                Thread.sleep(nextDieAt - TimeUtil.now());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

