/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.codegen.ClassReader;
import electric.util.io.Streams;
import electric.util.java.JavaInterface;
import electric.util.reflect.JavaMethod;
import electric.util.reflect.Reflect;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;

public final class MethodFinder {
    private static final JavaMethod NO_METHOD = new JavaMethod();
    private static final JavaMethod[] NO_METHODS = new JavaMethod[0];
    private static final Hashtable classToJavaMethods = new Hashtable();
    private static final Hashtable methodToJavaMethod = new Hashtable();

    public static synchronized JavaMethod getMethod(Method method) {
        JavaInterface javaInterface;
        Method iMethod;
        JavaMethod javaMethod = (JavaMethod)methodToJavaMethod.get(method);
        if (javaMethod != null) {
            return javaMethod == NO_METHOD ? null : javaMethod;
        }
        Class<?> javaClass = method.getDeclaringClass();
        Method method2 = iMethod = javaClass.isInterface() ? method : Reflect.getInterfaceMethod(method);
        if (iMethod != null && (javaInterface = JavaInterface.getInterface(iMethod.getDeclaringClass())) != null) {
            javaMethod = javaInterface.getMethod(iMethod);
        }
        if (javaMethod == null) {
            JavaMethod[] javaMethods = (JavaMethod[])classToJavaMethods.get(javaClass);
            if (javaMethods == null) {
                try {
                    String filename = "/" + javaClass.getName().replace('.', '/') + ".class";
                    InputStream input = javaClass.getResourceAsStream(filename);
                    byte[] bytes = Streams.readFully(input);
                    input.close();
                    ClassReader reader = new ClassReader(bytes);
                    javaMethods = reader.methods;
                }
                catch (Exception exception) {
                    javaMethods = NO_METHODS;
                }
            }
            classToJavaMethods.put(javaClass, javaMethods);
            int i = 0;
            while (i < javaMethods.length) {
                if (javaMethods[i].matches(method)) {
                    javaMethod = javaMethods[i];
                    break;
                }
                ++i;
            }
        }
        if (javaMethod == null) {
            methodToJavaMethod.put(method, NO_METHOD);
            return null;
        }
        methodToJavaMethod.put(method, javaMethod);
        return javaMethod;
    }
}

