/*
 * Decompiled with CFR 0.152.
 */
package electric.util.list;

import electric.util.list.ListEnumeration;
import electric.util.list.ListNode;

public final class LinkedList {
    ListNode first;
    ListNode last;

    public synchronized boolean isEmpty() {
        return this.first == null;
    }

    public synchronized void add(ListNode node) {
        node.remove();
        node.list = this;
        node.prev = this.last;
        if (this.first == null) {
            this.first = node;
        } else {
            this.last.next = node;
        }
        this.last = node;
    }

    public synchronized void remove(ListNode node) {
        if (node.prev == null) {
            this.first = node.next;
        } else {
            node.prev.next = node.next;
        }
        if (node.next == null) {
            this.last = node.prev;
        } else {
            node.next.prev = node.prev;
        }
        node.list = null;
    }

    public synchronized void replace(ListNode oldNode, ListNode newNode) {
        newNode.remove();
        newNode.list = this;
        if (oldNode.prev == null) {
            this.first = newNode;
        } else {
            oldNode.prev.next = newNode;
        }
        if (oldNode.next == null) {
            this.last = newNode;
        } else {
            oldNode.next.prev = newNode;
        }
        newNode.prev = oldNode.prev;
        newNode.next = oldNode.next;
    }

    public synchronized void add(ListNode node, ListNode newNode) {
        newNode.remove();
        newNode.list = this;
        newNode.next = node.next;
        newNode.prev = node;
        if (node.next == null) {
            this.last = newNode;
        } else {
            node.next.prev = newNode;
        }
        node.next = newNode;
    }

    public synchronized void insert(ListNode node, ListNode newNode) {
        newNode.remove();
        newNode.list = this;
        newNode.prev = node.prev;
        newNode.next = node;
        if (node.prev == null) {
            this.first = newNode;
        } else {
            node.prev.next = newNode;
        }
        node.prev = newNode;
    }

    public ListNode getFirst() {
        return this.first;
    }

    public ListNode getLast() {
        return this.last;
    }

    public synchronized int size() {
        int count = 0;
        ListNode node = this.first;
        while (node != null) {
            ++count;
            node = node.next;
        }
        return count;
    }

    public synchronized void clear() {
        this.first = null;
        this.last = null;
    }

    public synchronized ListEnumeration elements() {
        return new ListEnumeration(this);
    }
}

