/*
 * Decompiled with CFR 0.152.
 */
package electric.util.license;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.license.Codec;
import electric.util.license.ILicenseConstants;
import electric.util.license.LicenseInfo;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IProductConfig;
import electric.util.product.Product;
import electric.util.resourceloader.ResourceLoaders;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public final class License
implements ILoggingConstants,
ILicenseConstants {
    private static final String LICENSEFILE = "-license";
    private static final String LICENSEFILE_EXT = ".xml";
    private static final HashMap productLicenses = new HashMap();

    public static IProductConfig getProductConfig(String[] products) throws LicensingException {
        IProductConfig productConfig = null;
        String[] licenseFiles = License.createLicenseFileList(products);
        int i = 0;
        while (i < licenseFiles.length) {
            String licenseFile = licenseFiles[i];
            try {
                byte[] bytes = ResourceLoaders.loadResource(licenseFile);
                Document licenseDoc = new Document(bytes);
                if (Log.isLogging(ILoggingConstants.LICENSE_EVENT)) {
                    Log.log(ILoggingConstants.LICENSE_EVENT, (Object)(licenseFile + " has been successfully loaded and parsed"));
                }
                productConfig = License.getProductConfig(licenseDoc.getRoot());
                break;
            }
            catch (IOException exception) {
            }
            catch (ParseException exception) {
                if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                    Log.log(ILoggingConstants.ERROR_EVENT, "unable to parse " + licenseFile, exception);
                }
            }
            catch (LicensingException exception) {
                throw exception;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++i;
        }
        if (productConfig == null) {
            throw new LicensingException("unable to find licensing information");
        }
        return productConfig;
    }

    private static String[] createLicenseFileList(String[] products) {
        Vector<String> licenseFiles = new Vector<String>();
        int i = 0;
        while (i < products.length) {
            licenseFiles.addElement(products[i] + LICENSEFILE + LICENSEFILE_EXT);
            ++i;
        }
        Object[] fileNames = new String[licenseFiles.size()];
        licenseFiles.copyInto(fileNames);
        return fileNames;
    }

    private static IProductConfig getProductConfig(Element licenseFileRoot) throws Exception {
        String productConfigClass = licenseFileRoot.getString("product");
        String userId = licenseFileRoot.getString("userId");
        Elements productKeys = licenseFileRoot.getElements("license");
        while (productKeys.hasMoreElements()) {
            Element licenseKeyElement = productKeys.next();
            String productName = licenseKeyElement.getString("product");
            String licenseKey = licenseKeyElement.getString("key");
            LicenseInfo licenseInfo = new LicenseInfo(licenseKey, userId);
            productLicenses.put(productName, licenseInfo);
        }
        return (IProductConfig)ClassLoaders.loadClass(productConfigClass).newInstance();
    }

    public static void verifyLicense(IProductConfig productConfig) throws LicensingException {
        String productName = productConfig.getProductInfo().getName();
        LicenseInfo licenseInfo = (LicenseInfo)productLicenses.get(productName);
        Hashtable constraints = License.verifyLicense(licenseInfo, productConfig);
        License.enforceMainframeConstraints(constraints);
        try {
            licenseInfo.setConstraints(constraints);
        }
        catch (Exception exception) {}
    }

    private static Hashtable verifyLicense(LicenseInfo licenseInfo, IProductConfig productConfig) throws LicensingException {
        int productId = productConfig.getProductInfo().getId();
        int majorVersion = productConfig.getProductInfo().getMajorVersion();
        String activationCode = licenseInfo.getActivationCode();
        String userId = licenseInfo.getUserId();
        Hashtable constraints = License.checkLicenseConsistency(activationCode, userId, productId, majorVersion);
        licenseInfo.setProductId(productId);
        productConfig.getProductInfo().setLicenseInfo(licenseInfo);
        return constraints;
    }

    private static Hashtable checkLicenseConsistency(String actCode, String userId, int productId, int majorVersion) throws LicensingException {
        Codec codec = new Codec();
        return codec.validate(actCode, userId, productId, majorVersion);
    }

    public static boolean isClientLicense() {
        return Product.getProductConfig().getProductInfo().getLicenseInfo().isClientLicense();
    }

    public static boolean isNetworkLockedLicense() {
        LicenseInfo licenseInfo = Product.getProductConfig().getProductInfo().getLicenseInfo();
        Integer licenseTypeObj = (Integer)licenseInfo.getProperty("licenseKeyType");
        if (licenseTypeObj == null) {
            return false;
        }
        int licenseType = licenseTypeObj;
        return licenseType == 256;
    }

    private static void enforceMainframeConstraints(Hashtable constraints) throws LicensingException {
        byte[] prepBytes;
        String nodeLockInfo = (String)constraints.get("nodeLockInfo");
        if (nodeLockInfo == null || nodeLockInfo.charAt(0) != '9') {
            return;
        }
        byte[] bytes = "version".getBytes();
        try {
            prepBytes = "version".getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LicensingException("Unrecoverable error while processing license.");
        }
        if (!ArrayUtil.equals(prepBytes, bytes)) {
            throw License.newMainframeLicenseException();
        }
        if (Strings.getBoolean(Context.getSystemProperty("platform.notASCII"), false)) {
            throw License.newMainframeLicenseException();
        }
    }

    private static LicensingException newMainframeLicenseException() {
        return new LicensingException("This version of Glue professional is not licensed to run on this operating system.  If you feel this message has been received in error, contact sales@themindelectric.com for more details.");
    }
}

