/*
 * Decompiled with CFR 0.152.
 */
package electric.util.encoding;

public class HexEncoding {
    private static final byte[] hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static byte[] encode(byte[] in) {
        byte[] out = new byte[in.length * 2];
        HexEncoding.encode(in, 0, in.length, out, 0);
        return out;
    }

    public static int encode(byte[] in, int inOff, int length, byte[] out, int outOff) {
        int i = 0;
        int j = 0;
        while (i < length) {
            out[outOff + j] = hexTable[in[inOff] >> 4 & 0xF];
            out[outOff + j + 1] = hexTable[in[inOff] & 0xF];
            ++inOff;
            ++i;
            j += 2;
        }
        return length * 2;
    }

    public static byte[] decode(byte[] in) {
        byte[] out = new byte[in.length / 2];
        HexEncoding.decode(in, 0, in.length, out, 0);
        return out;
    }

    public static int decode(byte[] in, int inOff, int length, byte[] out, int outOff) {
        int halfLength = length / 2;
        int i = 0;
        while (i < halfLength) {
            byte left = in[inOff + i * 2];
            byte right = in[inOff + i * 2 + 1];
            out[outOff] = left < 97 ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 97) {
                int n = outOff;
                out[n] = (byte)(out[n] + (byte)(right - 48));
            } else {
                int n = outOff;
                out[n] = (byte)(out[n] + (byte)(right - 97 + 10));
            }
            ++outOff;
            ++i;
        }
        return halfLength;
    }

    public static byte[] decode(String string) {
        byte[] bytes = new byte[string.length() / 2];
        String buf = string.toLowerCase();
        int i = 0;
        while (i < buf.length()) {
            char left = buf.charAt(i);
            char right = buf.charAt(i + 1);
            int index = i / 2;
            bytes[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                bytes[n] = (byte)(bytes[n] + (byte)(right - 48));
            } else {
                int n = index;
                bytes[n] = (byte)(bytes[n] + (byte)(right - 97 + 10));
            }
            i += 2;
        }
        return bytes;
    }
}

