/*
 * Decompiled with CFR 0.152.
 */
package electric.util.directory.monitored;

import electric.util.array.ArrayUtil;
import electric.util.directory.monitored.FileEvent;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredDirectory;
import electric.util.thread.Task;
import electric.util.thread.Tasks;
import java.io.File;
import java.io.FilenameFilter;

public class MonitoredRoot
implements Runnable {
    private static int SYNC_CYCLE = 5000;
    private static Tasks scheduler;
    private MonitoredDirectory root;
    private Task dirCycleTask;
    private IFileEventListener[] listeners = new IFileEventListener[0];

    public MonitoredRoot(File root) {
        this(root, false);
    }

    public MonitoredRoot(File root, boolean recurse) {
        this(root, recurse, true, null, false);
    }

    public MonitoredRoot(File root, boolean recurse, boolean start, FilenameFilter filter) {
        this(root, recurse, start, filter, false);
    }

    public MonitoredRoot(File root, boolean recurse, boolean start, FilenameFilter filter, boolean preCache) {
        this.root = new MonitoredDirectory(root, recurse, filter, preCache);
        if (start) {
            this.start();
        }
    }

    public static void setSyncCycle(int syncCycle) {
        SYNC_CYCLE = syncCycle;
    }

    public static int getSyncCycle() {
        return SYNC_CYCLE;
    }

    public void start() {
        if (scheduler == null) {
            scheduler = new Tasks();
            scheduler.setDaemon(true);
            scheduler.start();
        }
        this.dirCycleTask = scheduler.runAfter(this, 0L, this.root.getRoot().getAbsolutePath() + " directory monitor", SYNC_CYCLE, false);
    }

    public void run() {
        if (this.listeners.length == 0) {
            return;
        }
        this.cycle();
    }

    public void cycle() {
        FileEvent fileEvent = new FileEvent();
        this.root.update(fileEvent);
        this.notifyListeners(fileEvent);
    }

    public void stop() {
        if (scheduler != null) {
            scheduler.remove(this.dirCycleTask);
        }
    }

    public MonitoredDirectory getRoot() {
        return this.root;
    }

    public synchronized void addEventListener(IFileEventListener listener) {
        this.listeners = (IFileEventListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public synchronized void removeEventListener(IFileEventListener listener) {
        this.listeners = (IFileEventListener[])ArrayUtil.removeElement(this.listeners, listener);
    }

    public void removeAllListeners() {
        this.listeners = new IFileEventListener[0];
    }

    public void notifyListeners(IFileEventListener[] listeners) {
        FileEvent fileEvent = new FileEvent();
        this.root.update(fileEvent);
        this.notifyListeners(fileEvent, listeners);
    }

    private void notifyListeners(FileEvent fileEvent) {
        this.notifyListeners(fileEvent, this.listeners);
    }

    private void notifyListeners(FileEvent fileEvent, IFileEventListener[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            if (fileEvent.addedFiles.length != 0) {
                listeners[i].filesAdded(fileEvent.addedFiles);
            }
            if (fileEvent.modifiedFiles.length != 0) {
                listeners[i].filesModified(fileEvent.modifiedFiles);
            }
            if (fileEvent.removedFiles.length != 0) {
                listeners[i].filesRemoved(fileEvent.removedFiles);
            }
            ++i;
        }
    }
}

