/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.persistent;

import electric.util.WrappedException;
import electric.util.dictionary.DictionaryElements;
import electric.util.dictionary.persistent.Handle;
import electric.util.dictionary.persistent.IPersistentDictionary;
import electric.util.dictionary.persistent.Sync;
import electric.util.file.FileUtil;
import electric.util.string.Strings;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PersistentDictionary
extends Dictionary
implements IPersistentDictionary {
    public static final int VERSION = 1;
    private Hashtable keyToHandle = new Hashtable();
    private String root;
    private boolean encoded = true;
    private boolean sync;
    private boolean exists;

    public PersistentDictionary(String root) {
        this(root, false, false);
    }

    public PersistentDictionary(String root, boolean delete) {
        this(root, delete, false);
    }

    public PersistentDictionary(String root, boolean delete, boolean lazy) {
        this.root = root;
        File directory = new File(root);
        this.exists = directory.exists();
        if (!this.exists) {
            if (!lazy) {
                directory.mkdirs();
                this.exists = true;
            }
        } else if (delete) {
            FileUtil.delete(directory);
            if (lazy) {
                this.exists = false;
            } else {
                directory.mkdirs();
            }
        } else {
            Hashtable files = this.getFiles(directory);
            Enumeration enumeration = files.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                this.keyToHandle.put(key, new Handle(this, key, true));
            }
        }
    }

    public String toString() {
        return "PersistentDictionary( " + this.keyToHandle + " )";
    }

    public String getRoot() {
        return this.root;
    }

    public synchronized Object get(Object key) throws WrappedException {
        Handle handle = (Handle)this.keyToHandle.get(key);
        return handle == null ? null : handle.get();
    }

    public synchronized Object put(Object key, Object value) throws IllegalArgumentException, WrappedException {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a string");
        }
        Handle handle = (Handle)this.keyToHandle.get(key);
        if (handle == null) {
            handle = new Handle(this, (String)key, false);
            this.keyToHandle.put(key, handle);
        }
        if (!this.exists) {
            new File(this.root).mkdirs();
            this.exists = true;
        }
        return handle.put(value);
    }

    public synchronized Object remove(Object key) {
        Handle handle = (Handle)this.keyToHandle.remove(key);
        return handle == null ? null : handle.remove();
    }

    public int size() {
        return this.keyToHandle.size();
    }

    public boolean isEmpty() {
        return this.keyToHandle.isEmpty();
    }

    public Enumeration keys() {
        return this.keyToHandle.keys();
    }

    public Enumeration elements() {
        return new DictionaryElements(this);
    }

    public synchronized Object peek(Object key) {
        Handle handle = (Handle)this.keyToHandle.get(key);
        return handle == null ? null : handle.peek();
    }

    public synchronized Object load(Object key) throws WrappedException {
        Handle handle = (Handle)this.keyToHandle.get(key);
        return handle == null ? null : handle.load();
    }

    public synchronized void clear() {
        Enumeration enumeration = this.keyToHandle.elements();
        while (enumeration.hasMoreElements()) {
            ((Handle)enumeration.nextElement()).delete();
        }
        this.keyToHandle.clear();
    }

    public synchronized void delete() {
        this.clear();
        new File(this.root).delete();
    }

    Hashtable getFiles(File directory) {
        Hashtable<String, File> table = new Hashtable<String, File>();
        File[] files = FileUtil.listFiles(directory);
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith(".xml")) {
                String key = Strings.fromFilename(Strings.head(files[i].getName(), '.'));
                table.put(key, files[i]);
            }
            ++i;
        }
        return table;
    }

    public boolean getEncoded() {
        return this.encoded;
    }

    public void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    public static void setSyncCycle(int milliseconds) {
        Sync.setSyncCycle(milliseconds);
    }

    public void setSync(boolean flag) {
        if (flag && !this.sync) {
            Sync.addDictionary(this);
        } else if (this.sync && !flag) {
            Sync.removeDictionary(this);
        }
        this.sync = flag;
    }

    public boolean getSync() {
        return this.sync;
    }

    public synchronized void sync() {
        Handle handle;
        if (!this.sync || !this.exists) {
            return;
        }
        Hashtable files = this.getFiles(new File(this.root));
        Enumeration enumeration = files.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            File file = (File)files.get(key);
            handle = (Handle)this.keyToHandle.get(key);
            if (handle == null) {
                this.keyToHandle.put(key, new Handle(this, key, true));
                continue;
            }
            if (handle.getLastModifiedTime() <= 0L || handle.getLastModifiedTime() >= file.lastModified()) continue;
            handle.reload();
        }
        Vector<Handle> removed = new Vector<Handle>();
        Enumeration enum2 = this.keyToHandle.elements();
        while (enum2.hasMoreElements()) {
            handle = (Handle)enum2.nextElement();
            if (!handle.hasFile() || files.get(handle.getKey()) != null) continue;
            removed.addElement(handle);
        }
        Enumeration enum3 = removed.elements();
        while (enum3.hasMoreElements()) {
            Handle handle2 = (Handle)enum3.nextElement();
            this.keyToHandle.remove(handle2.getKey());
            handle2.remove();
        }
    }
}

