/*
 * Decompiled with CFR 0.152.
 */
package electric.util.constructor;

import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.constructor.IInstantiator;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public class Constructor
implements IInstantiator {
    public String[] args = new String[0];
    public Class[] argClasses = new Class[0];
    public String className;
    protected transient ClassLoader loader;

    public Constructor() {
    }

    public Constructor(String className, String[] args) {
        this.className = className;
        this.args = args;
    }

    public Constructor(String className, Class[] argClasses, String[] args) {
        this.className = className;
        this.args = args;
        this.argClasses = argClasses;
    }

    public Constructor(Element element) {
        this.className = element.getElement("class").getString();
        this.args = this.getArgs(element);
    }

    public void writeDescriptor(Element descriptor) {
        Element constructor = descriptor.addElement("constructor");
        constructor.setString("class", this.className);
        Element argsElement = constructor.addElement("args");
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                Element arg = argsElement.addElement("arg").setText(this.args[i]);
                if (this.argClasses != null && this.argClasses.length > 0) {
                    try {
                        arg.setAttribute("type", this.argClasses[i].getName());
                    }
                    catch (IndexOutOfBoundsException ignore) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public Element getDescriptor() {
        Element constructor = new Element("constructor");
        constructor.setString("class", this.className);
        Element argsElement = constructor.addElement("args");
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                Element arg = argsElement.addElement("arg").setText(this.args[i]);
                if (this.argClasses != null && this.argClasses.length > 0) {
                    try {
                        arg.setAttribute("type", this.argClasses[i].getName());
                    }
                    catch (IndexOutOfBoundsException ignore) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return constructor;
    }

    public Object newInstance() throws Throwable {
        Class clazz = ClassLoaders.loadClass(this.className, this.loader);
        if (this.argClasses.length > 0) {
            return Creator.newInstance(clazz, this.argClasses, this.args);
        }
        return Creator.newInstance(clazz, this.args);
    }

    public Class getReturnType() throws ClassNotFoundException {
        return ClassLoaders.loadClass(this.className, this.loader);
    }

    public String getClassName() {
        return this.className;
    }

    private String[] getArgs(Element element) {
        Element argElement = element.getElement("args");
        String[] args = new String[]{};
        if (argElement == null) {
            return args;
        }
        Elements elements = argElement.getElements();
        args = new String[elements.size()];
        int i = 0;
        while (elements.hasMoreElements()) {
            Element arg = elements.next();
            args[i] = arg.getString();
            String type = arg.getAttributeValue("type");
            if (type != null) {
                try {
                    Class<?> argType = Class.forName(type);
                    this.argClasses = (Class[])ArrayUtil.addElement(this.argClasses, argType);
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
            }
            ++i;
        }
        return args;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

