/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server;

import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.Servers;
import electric.server.http.ServletServer;
import electric.uddi.Assertion;
import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.Business;
import electric.uddi.DispositionReport;
import electric.uddi.ICommand;
import electric.uddi.IUDDIConstants;
import electric.uddi.IUDDIListener;
import electric.uddi.IUDDIServer;
import electric.uddi.Service;
import electric.uddi.Subscription;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.admin.IAdmin;
import electric.uddi.admin.User;
import electric.uddi.server.IUDDIStorage;
import electric.uddi.server.UDDIAdmin;
import electric.uddi.server.UDDIDictionary;
import electric.uddi.server.UDDISOAPHandler;
import electric.uddi.server.UDDIServlet;
import electric.uddi.server.file.FileUDDIStorage;
import electric.util.array.ArrayUtil;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.io.literal.LiteralReader;
import java.util.Enumeration;
import java.util.Vector;

public final class UDDIServer
implements IUDDIServer,
IAdmin,
IUDDIConstants,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;
    private static final Vector defaultTModels = new Vector();
    private String siteOperator;
    private UDDISOAPHandler inquiryHandler;
    private UDDISOAPHandler publicationHandler;
    private ServletServer inquiryServlet;
    private UDDIAdmin admin;
    private UDDIDictionary tModels;
    private UDDIDictionary bindings;
    private UDDIDictionary services;
    private UDDIDictionary businesses;
    private UDDIDictionary assertions;
    private UDDIDictionary subscriptions;
    private UDDIDictionary users;
    private IUDDIListener[] listeners = new IUDDIListener[0];
    static /* synthetic */ Class class$electric$uddi$admin$IAdmin;
    static /* synthetic */ Class class$electric$uddi$TModel;
    static /* synthetic */ Class class$electric$uddi$admin$User;
    static /* synthetic */ Class class$electric$uddi$Service;
    static /* synthetic */ Class class$electric$uddi$Binding;
    static /* synthetic */ Class class$electric$uddi$Business;
    static /* synthetic */ Class class$electric$uddi$Assertion;
    static /* synthetic */ Class class$electric$uddi$Subscription;

    public UDDIServer(String inquiryURL, String publicationURL, String adminURL, String root, boolean delete) throws RegistryException, UDDIException {
        this(inquiryURL, publicationURL, adminURL, new FileUDDIStorage(root, delete));
    }

    public UDDIServer(String inquiryURL, String publicationURL, String adminURL, IUDDIStorage factory) throws RegistryException, UDDIException {
        this(inquiryURL, publicationURL, adminURL, factory, true);
    }

    public UDDIServer(String inquiryURL, String publicationURL, String adminURL, IUDDIStorage factory, boolean initTModels) throws RegistryException, UDDIException {
        if (!UDDIServer.isEnabled()) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"GLUE standard UDDI server only holds up to 5 services");
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"for unlimited storage, upgrade to GLUE professional");
        }
        DispositionReport.setUDDIServer(this);
        this.initUDDIServices(inquiryURL, publicationURL, adminURL);
        this.initServlet(inquiryURL);
        this.initDictionaries(factory, initTModels);
    }

    private void initUDDIServices(String inquiryURL, String publicationURL, String adminURL) throws RegistryException {
        this.inquiryHandler = new UDDISOAPHandler(this, IUDDIConstants.INQUIRY_METHODS);
        Registry.publish(inquiryURL, this.inquiryHandler);
        this.publicationHandler = new UDDISOAPHandler(this, IUDDIConstants.PUBLISH_METHODS);
        Registry.publish(publicationURL, this.publicationHandler);
        Registry.publish(adminURL, (Object)this, class$electric$uddi$admin$IAdmin == null ? (class$electric$uddi$admin$IAdmin = UDDIServer.class$("electric.uddi.admin.IAdmin")) : class$electric$uddi$admin$IAdmin);
    }

    private void initDictionaries(IUDDIStorage factory, boolean initTModels) {
        boolean tModelsExist = factory.doesDictionaryExist(class$electric$uddi$TModel == null ? (class$electric$uddi$TModel = UDDIServer.class$("electric.uddi.TModel")) : class$electric$uddi$TModel);
        this.users = factory.newDictionary(class$electric$uddi$admin$User == null ? (class$electric$uddi$admin$User = UDDIServer.class$("electric.uddi.admin.User")) : class$electric$uddi$admin$User, true);
        this.services = factory.newDictionary(class$electric$uddi$Service == null ? (class$electric$uddi$Service = UDDIServer.class$("electric.uddi.Service")) : class$electric$uddi$Service, false);
        this.bindings = factory.newDictionary(class$electric$uddi$Binding == null ? (class$electric$uddi$Binding = UDDIServer.class$("electric.uddi.Binding")) : class$electric$uddi$Binding, false);
        this.tModels = factory.newDictionary(class$electric$uddi$TModel == null ? (class$electric$uddi$TModel = UDDIServer.class$("electric.uddi.TModel")) : class$electric$uddi$TModel, false);
        this.businesses = factory.newDictionary(class$electric$uddi$Business == null ? (class$electric$uddi$Business = UDDIServer.class$("electric.uddi.Business")) : class$electric$uddi$Business, false);
        this.assertions = factory.newDictionary(class$electric$uddi$Assertion == null ? (class$electric$uddi$Assertion = UDDIServer.class$("electric.uddi.Assertion")) : class$electric$uddi$Assertion, false);
        this.subscriptions = factory.newDictionary(class$electric$uddi$Subscription == null ? (class$electric$uddi$Subscription = UDDIServer.class$("electric.uddi.Subscription")) : class$electric$uddi$Subscription, false);
        this.admin = new UDDIAdmin(this, this.users);
        if (initTModels && (factory.isDelete() || !tModelsExist)) {
            this.initializeTModels();
        }
    }

    private void initServlet(String inquiryURL) {
        this.inquiryServlet = (ServletServer)Servers.getServerForLocalPath(Strings.splice("/", inquiryURL));
        this.inquiryServlet.addHandler(new UDDIServlet(this), -1);
    }

    public String getInquiryServletPath() {
        return this.inquiryServlet.getPath().toString();
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("UDDI Server cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"UDDI server disabled");
    }

    public void addListener(IUDDIListener listener) {
        this.listeners = (IUDDIListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public IUDDIListener[] getListeners() {
        return this.listeners;
    }

    public IAdmin getAdmin() {
        return this.admin;
    }

    public String getOperator() {
        return this.siteOperator;
    }

    public void setOperator(String siteOperator) {
        this.siteOperator = siteOperator;
    }

    public synchronized Object invoke(ICommand command, Authorization authorization) throws UDDIException {
        return command.invoke(this, authorization);
    }

    public Enumeration getBusinesses() {
        return this.businesses.elements();
    }

    public Enumeration getBusinessKeys() {
        return this.businesses.keys();
    }

    public Business[] getBusinessesForUser(User user) throws UDDIException {
        Vector<Business> vector = new Vector<Business>();
        Enumeration enumeration = this.getBusinessKeys();
        while (enumeration.hasMoreElements()) {
            String businessKey = (String)enumeration.nextElement();
            Business business = this.readBusiness(businessKey);
            if (!user.getName().equals(business.getUserName())) continue;
            vector.addElement(business);
        }
        Object[] businesses = new Business[vector.size()];
        vector.copyInto(businesses);
        return businesses;
    }

    public boolean ownsBusiness(String businessKey, User user) throws UDDIException {
        Business business = this.readBusiness(businessKey);
        return user.getName().equals(business.getUserName());
    }

    public Business readBusiness(String businessKey) throws UDDIException {
        return (Business)this.businesses.get(businessKey);
    }

    public void writeBusiness(Business business) throws UDDIException {
        this.businesses.put(business.getBusinessKey(), business);
    }

    public void eraseBusiness(String businessKey) throws UDDIException {
        this.businesses.remove(businessKey);
    }

    public Enumeration getServices() {
        return this.services.elements();
    }

    public Enumeration getServiceKeys() {
        return this.services.keys();
    }

    public Service[] getServicesForUser(User user) throws UDDIException {
        Vector<Service> vector = new Vector<Service>();
        Enumeration enumeration = this.getServiceKeys();
        while (enumeration.hasMoreElements()) {
            String serviceKey = (String)enumeration.nextElement();
            Service service = this.readService(serviceKey);
            if (!user.getName().equals(service.getUserName())) continue;
            vector.addElement(service);
        }
        Object[] services = new Service[vector.size()];
        vector.copyInto(services);
        return services;
    }

    public boolean ownsService(String serviceKey, User user) throws UDDIException {
        Service service = this.readService(serviceKey);
        return user.getName().equals(service.getUserName());
    }

    public String[] getServiceKeysForBusiness(String businessKey) throws UDDIException {
        Vector<String> matches = new Vector<String>();
        Enumeration enumeration = this.services.keys();
        while (enumeration.hasMoreElements()) {
            String serviceKey = (String)enumeration.nextElement();
            Service service = this.readService(serviceKey);
            if (!service.getBusinessKey().equals(businessKey)) continue;
            matches.addElement(service.getServiceKey());
        }
        Object[] keys = new String[matches.size()];
        matches.copyInto(keys);
        return keys;
    }

    public Service readService(String serviceKey) throws UDDIException {
        return (Service)this.services.get(serviceKey);
    }

    public void writeService(Service service) throws UDDIException {
        if (!enabled && this.services.size() >= 5 && this.services.peek(service.getServiceKey()) == null) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"UDDI storage limit exceeded");
            throw new UDDIException(10160);
        }
        this.services.put(service.getServiceKey(), service);
    }

    public void eraseService(String serviceKey) throws UDDIException {
        this.services.remove(serviceKey);
    }

    public Enumeration getBindings() {
        return this.bindings.elements();
    }

    public Enumeration getBindingKeys() {
        return this.bindings.keys();
    }

    public Binding[] getBindingsForUser(User user) throws UDDIException {
        Vector<Binding> vector = new Vector<Binding>();
        Enumeration enumeration = this.getBindingKeys();
        while (enumeration.hasMoreElements()) {
            String bindingKey = (String)enumeration.nextElement();
            Binding binding = this.readBinding(bindingKey);
            if (!user.getName().equals(binding.getUserName())) continue;
            vector.addElement(binding);
        }
        Object[] bindings = new Binding[vector.size()];
        vector.copyInto(bindings);
        return bindings;
    }

    public boolean ownsBinding(String bindingKey, User user) throws UDDIException {
        Binding binding = this.readBinding(bindingKey);
        return user.getName().equals(binding.getUserName());
    }

    public String[] getBindingKeysForService(String serviceKey) throws UDDIException {
        Vector<String> matches = new Vector<String>();
        Enumeration enumeration = this.bindings.keys();
        while (enumeration.hasMoreElements()) {
            String bindingKey = (String)enumeration.nextElement();
            Binding binding = this.readBinding(bindingKey);
            if (!binding.getServiceKey().equals(serviceKey)) continue;
            matches.addElement(binding.getBindingKey());
        }
        Object[] keys = new String[matches.size()];
        matches.copyInto(keys);
        return keys;
    }

    public Binding readBinding(String bindingKey) throws UDDIException {
        return (Binding)this.bindings.get(bindingKey);
    }

    public void writeBinding(Binding binding) throws UDDIException {
        this.bindings.put(binding.getBindingKey(), binding);
    }

    public void eraseBinding(String bindingKey) throws UDDIException {
        this.bindings.remove(bindingKey);
    }

    public Enumeration getTModels() {
        return this.tModels.elements();
    }

    public Enumeration getTModelKeys() {
        return this.tModels.keys();
    }

    public TModel[] getTModelsForUser(User user) throws UDDIException {
        Vector<TModel> vector = new Vector<TModel>();
        Enumeration enumeration = this.getTModelKeys();
        while (enumeration.hasMoreElements()) {
            String tModelKey = (String)enumeration.nextElement();
            TModel tModel = this.readTModel(tModelKey);
            if (!user.getName().equals(tModel.getUserName())) continue;
            vector.addElement(tModel);
        }
        Object[] tModels = new TModel[vector.size()];
        vector.copyInto(tModels);
        return tModels;
    }

    public boolean ownsTModel(TModel tModel, User user) throws UDDIException {
        return user.getName().equals(tModel.getUserName());
    }

    public TModel readTModel(String tModelKey) throws UDDIException {
        return (TModel)this.tModels.get(tModelKey);
    }

    public void writeTModel(TModel tModel) throws UDDIException {
        this.tModels.put(tModel.getTModelKey(), tModel);
    }

    public void eraseTModel(String tModelKey) throws UDDIException {
        this.tModels.remove(tModelKey);
    }

    public static void setDefaultTModels(Enumeration tModels) {
        while (tModels.hasMoreElements()) {
            Element element = (Element)tModels.nextElement();
            TModel tModel = new TModel();
            try {
                tModel.read(new LiteralReader(element));
                defaultTModels.addElement(tModel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void initializeTModels() {
        Enumeration tModels = defaultTModels.elements();
        while (tModels.hasMoreElements()) {
            TModel tModel = (TModel)tModels.nextElement();
            try {
                this.writeTModel(tModel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Enumeration getAssertions() {
        return this.assertions.elements();
    }

    public Enumeration getAssertionKeys() {
        return this.assertions.keys();
    }

    public Assertion[] getAssertionsForUser(User user) throws UDDIException {
        Vector<Assertion> vector = new Vector<Assertion>();
        String userName = user.getName();
        Enumeration enumeration = this.getAssertionKeys();
        while (enumeration.hasMoreElements()) {
            String assertionKey = (String)enumeration.nextElement();
            Assertion assertion = this.readAssertion(assertionKey);
            if (!userName.equals(assertion.getToUserName()) && !userName.equals(assertion.getFromUserName())) continue;
            vector.addElement(assertion);
        }
        Object[] assertions = new Assertion[vector.size()];
        vector.copyInto(assertions);
        return assertions;
    }

    public boolean publishedAssertion(Assertion assertion, User user) throws UDDIException {
        String userName = user.getName();
        return userName.equals(assertion.getToUserName()) || userName.equals(assertion.getFromUserName());
    }

    public Assertion readAssertion(String assertionKey) throws UDDIException {
        return (Assertion)this.assertions.get(assertionKey);
    }

    public void writeAssertion(Assertion assertion) throws UDDIException {
        this.assertions.put(assertion.getAssertionKey(), assertion);
    }

    public void eraseAssertion(String assertionKey) throws UDDIException {
        this.assertions.remove(assertionKey);
    }

    public Enumeration getSubscriptions() {
        return this.subscriptions.elements();
    }

    public Subscription readSubscription(String subscriptionKey) throws UDDIException {
        return (Subscription)this.subscriptions.get(subscriptionKey);
    }

    public void writeSubscription(Subscription subscription) throws UDDIException {
        this.subscriptions.put(subscription.getSubscriptionKey(), subscription);
    }

    public void eraseSubscription(String subscriptionKey) throws UDDIException {
        this.subscriptions.remove(subscriptionKey);
    }

    public User getPublisher(Authorization authorization) throws UDDIException {
        return this.admin.getPublisher(authorization);
    }

    public void checkLimits(User user) throws UDDIException {
        this.admin.checkLimits(user);
    }

    public User readUser(String name) throws UDDIException {
        return this.admin.getUser(name);
    }

    public User[] getUsers() throws UDDIException {
        return this.admin.getUsers();
    }

    public User getUser(String name) throws UDDIException {
        return this.admin.getUser(name);
    }

    public User saveUser(User user) throws UDDIException {
        return this.admin.saveUser(user);
    }

    public void deleteUser(String name) throws UDDIException {
        this.admin.deleteUser(name);
    }

    public void deleteUsers() throws UDDIException {
        this.admin.deleteUsers();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Product.startup();
    }
}

