/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server;

import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.DeleteBusinesses;
import electric.uddi.DeleteTModels;
import electric.uddi.IUDDIConstants;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.admin.IAdmin;
import electric.uddi.admin.User;
import electric.uddi.server.UDDIDictionary;
import electric.uddi.server.UDDIServer;
import electric.util.string.Base64;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class UDDIAdmin
implements IAdmin,
IUDDIConstants {
    private UDDIServer server;
    private UDDIDictionary users;

    public UDDIAdmin(UDDIServer server, UDDIDictionary users) {
        this.server = server;
        this.users = users;
    }

    public synchronized Authorization getAuthorization(String name, String password, String version) throws UDDIException {
        User user = null;
        try {
            user = this.getUser(name);
        }
        catch (UDDIException exception) {
            throw new UDDIException(10150);
        }
        if (!user.getPassword().equals(password)) {
            throw new UDDIException(10150);
        }
        String token = Base64.toBase64((user.getName() + "|" + user.getPassword()).getBytes());
        return new Authorization(token);
    }

    public synchronized void discardAuthorization(Authorization authorization, String version) throws UDDIException {
    }

    public synchronized User[] getUsers() throws UDDIException {
        User[] array = new User[this.users.size()];
        int index = 0;
        Enumeration enumeration = this.users.elements();
        while (enumeration.hasMoreElements()) {
            array[index++] = (User)enumeration.nextElement();
        }
        return array;
    }

    public synchronized void checkLimits(User user) throws UDDIException {
        if (this.server.getBusinessesForUser(user).length > user.getMaxBusinesses()) {
            throw new UDDIException(10160);
        }
        if (this.server.getServicesForUser(user).length > user.getMaxServices()) {
            throw new UDDIException(10160);
        }
        if (this.server.getBindingsForUser(user).length > user.getMaxBindings()) {
            throw new UDDIException(10160);
        }
        if (this.server.getTModelsForUser(user).length > user.getMaxTModels()) {
            throw new UDDIException(10160);
        }
        if (this.server.getAssertionsForUser(user).length > user.getMaxAssertions()) {
            throw new UDDIException(10160);
        }
        this.users.put(user.getName(), user);
    }

    public synchronized User getUser(String name) throws UDDIException {
        return (User)this.users.get(name);
    }

    public synchronized void deleteUser(String name) throws UDDIException {
        User user = this.getUser(name);
        try {
            Transaction.begin();
            this.deleteUser(user);
            Transaction.commit();
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public synchronized void deleteUsers() throws UDDIException {
        User[] users = this.getUsers();
        try {
            Transaction.begin();
            int i = 0;
            while (i < users.length) {
                this.deleteUser(users[i]);
                ++i;
            }
            Transaction.commit();
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public synchronized void deleteUser(User user) throws UDDIException {
        Business[] businesses = this.server.getBusinessesForUser(user);
        int i = 0;
        while (i < businesses.length) {
            DeleteBusinesses.deleteBusiness(this.server, businesses[i].getBusinessKey(), user);
            ++i;
        }
        TModel[] tModels = this.server.getTModelsForUser(user);
        int i2 = 0;
        while (i2 < tModels.length) {
            DeleteTModels.deleteTModel(this.server, tModels[i2], user);
            ++i2;
        }
    }

    public synchronized User saveUser(User user) throws UDDIException {
        this.checkLimits(user);
        return user;
    }

    public synchronized User getPublisher(Authorization authorization) throws UDDIException {
        String token = new String(Base64.fromBase64(authorization.getToken()));
        StringTokenizer tokenizer = new StringTokenizer(token, "|");
        String name = tokenizer.nextToken();
        String password = tokenizer.nextToken();
        User user = this.getUser(name);
        if (user == null || !password.equals(user.getPassword())) {
            throw new UDDIException(10120);
        }
        this.checkPublish(user);
        return user;
    }

    public synchronized void checkPublish(User user) throws UDDIException {
        if (!user.getPublish()) {
            throw new UDDIException(10120);
        }
    }
}

