/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Description;
import electric.uddi.IUDDIConstants;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class Overview
implements ISerializable,
IUDDIConstants {
    private Description[] descriptions = new Description[0];
    private String overviewURL;

    public Overview() {
    }

    public Overview(Description description, String overviewURL) {
        this.addDescription(description);
        this.overviewURL = overviewURL;
    }

    public String toString() {
        return "Overview( description: " + this.descriptions + ", overviewURL: " + this.overviewURL + " )";
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void setOverviewURL(String overviewURL) {
        this.overviewURL = overviewURL;
    }

    public String getOverviewURL() {
        return this.overviewURL;
    }

    public void write(IWriter writer) throws IOException {
        IWriter entity = writer.writeElement("overviewDoc");
        Description.writeList(entity, this.descriptions);
        if (this.overviewURL != null) {
            entity.writeString("overviewURL", this.overviewURL);
        }
    }

    public void read(IReader reader) throws IOException {
        this.descriptions = Description.readList(reader);
        this.overviewURL = reader.readString("overviewURL");
    }
}

