/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.BusinessExtended;
import electric.uddi.BusinessesExtended;
import electric.uddi.GetBusinesses;
import electric.uddi.GetServices;
import electric.uddi.IUDDIServer;
import electric.uddi.Service;
import electric.uddi.UDDIException;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class GetBusinessesExtended
extends GetBusinesses {
    public GetBusinessesExtended() {
    }

    public GetBusinessesExtended(String[] businessKeys) {
        super(businessKeys);
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        Business[] results = new BusinessExtended[this.businessKeys.length];
        int i = 0;
        while (i < results.length) {
            results[i] = this.getBusinessExtended(server, this.businessKeys[i]);
            ++i;
        }
        return new BusinessesExtended(results);
    }

    private BusinessExtended getBusinessExtended(IUDDIServer server, String businessKey) throws UDDIException {
        BusinessExtended business = new BusinessExtended(server.readBusiness(businessKey));
        String[] serviceKeys = server.getServiceKeysForBusiness(businessKey);
        Service[] fullServices = new Service[serviceKeys.length];
        int i = 0;
        while (i < serviceKeys.length) {
            fullServices[i] = GetServices.getService(server, serviceKeys[i]);
            ++i;
        }
        business.setServices(fullServices);
        return business;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("get_businessDetailExt");
        int i = 0;
        while (i < this.businessKeys.length) {
            query.writeString("businessKey", this.businessKeys[i]);
            ++i;
        }
    }
}

