/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.BusinessInfo;
import electric.uddi.BusinessInfos;
import electric.uddi.Category;
import electric.uddi.DiscoveryURL;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Identifier;
import electric.uddi.Name;
import electric.uddi.Qualifier;
import electric.uddi.Service;
import electric.uddi.ServiceInfo;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.selectors.AndSelector;
import electric.uddi.selectors.BusinessTModelSelector;
import electric.uddi.selectors.CategorySelector;
import electric.uddi.selectors.CombinedCategorySelector;
import electric.uddi.selectors.DiscoveryURLSelector;
import electric.uddi.selectors.ISelector;
import electric.uddi.selectors.IdentifierSelector;
import electric.uddi.selectors.NameSelector;
import electric.uddi.selectors.OrSelector;
import electric.uddi.selectors.ServiceCategorySelector;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;
import java.util.Enumeration;

public final class FindBusinesses
implements IInquiryCommand,
ISubscriptionFilter {
    private Name[] names;
    private Identifier[] identifiers;
    private Category[] categories;
    private String[] tModelKeys;
    private DiscoveryURL[] discoveryURLs;
    private Qualifier qualifier = Qualifier.DEFAULT;
    private transient AndSelector selector;

    public FindBusinesses() {
    }

    public FindBusinesses(Name[] names, Identifier[] identifiers, Category[] categories, String[] tModelKeys, DiscoveryURL[] discoveryURLs, Qualifier qualifier) {
        this.names = names;
        this.identifiers = identifiers;
        this.categories = categories;
        this.tModelKeys = tModelKeys;
        this.discoveryURLs = discoveryURLs;
        this.qualifier = qualifier != null ? qualifier : Qualifier.DEFAULT;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public Name[] getNames() {
        return this.names;
    }

    public void setNames(Name[] names) {
        this.names = names;
    }

    public Identifier[] getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Identifier[] identifiers) {
        this.identifiers = identifiers;
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public String[] getTModelKeys() {
        return this.tModelKeys;
    }

    public void setTModelKeys(String[] tModelKeys) {
        this.tModelKeys = tModelKeys;
    }

    public DiscoveryURL[] getDiscoveryURLs() {
        return this.discoveryURLs;
    }

    public void setDiscoveryURLs(DiscoveryURL[] discoveryURLs) {
        this.discoveryURLs = discoveryURLs;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    public String getVersion() {
        int count = 0;
        if (this.names != null) {
            ++count;
        }
        if (this.identifiers != null) {
            ++count;
        }
        if (this.categories != null) {
            ++count;
        }
        if (this.tModelKeys != null) {
            ++count;
        }
        if (this.discoveryURLs != null) {
            ++count;
        }
        return count > 1 || this.names != null && this.names.length > 1 ? "2.0" : "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        if (this.qualifier.getServiceSubset()) {
            return this.findBusinessesUsingServiceSubset(server);
        }
        return this.findBusinesses(server);
    }

    private BusinessInfos findBusinesses(IUDDIServer server) throws UDDIException {
        ISelector selector = this.getSelector();
        BusinessInfo[] matches = new BusinessInfo[]{};
        Enumeration enumeration = server.getBusinesses();
        while (enumeration.hasMoreElements()) {
            Business business = (Business)enumeration.nextElement();
            if (!selector.selects(server, business)) continue;
            String[] serviceKeys = server.getServiceKeysForBusiness(business.getBusinessKey());
            ServiceInfo[] serviceInfos = new ServiceInfo[serviceKeys.length];
            int i = 0;
            while (i < serviceInfos.length) {
                serviceInfos[i] = new ServiceInfo(server.readService(serviceKeys[i]));
                ++i;
            }
            matches = (BusinessInfo[])ArrayUtil.addElement(matches, new BusinessInfo(business, serviceInfos));
        }
        return new BusinessInfos(matches, false);
    }

    private BusinessInfos findBusinessesUsingServiceSubset(IUDDIServer server) throws UDDIException {
        ISelector selector = this.getSelector();
        BusinessInfo[] matches = new BusinessInfo[]{};
        OrSelector serviceSelector = new OrSelector();
        int i = 0;
        while (i < this.categories.length) {
            serviceSelector.addSelector(new CategorySelector(this.categories[i]));
            ++i;
        }
        Enumeration enumeration = server.getBusinesses();
        while (enumeration.hasMoreElements()) {
            Business business = (Business)enumeration.nextElement();
            if (!selector.selects(server, business)) continue;
            String[] serviceKeys = server.getServiceKeysForBusiness(business.getBusinessKey());
            ServiceInfo[] serviceInfos = new ServiceInfo[]{};
            int i2 = 0;
            while (i2 < serviceKeys.length) {
                Service service = server.readService(serviceKeys[i2]);
                if (serviceSelector.selects(null, service)) {
                    serviceInfos = (ServiceInfo[])ArrayUtil.addElement(serviceInfos, new ServiceInfo(service));
                }
                ++i2;
            }
            matches = (BusinessInfo[])ArrayUtil.addElement(matches, new BusinessInfo(business, serviceInfos));
        }
        return new BusinessInfos(matches, false);
    }

    public synchronized ISelector getSelector() {
        int i;
        if (this.selector != null) {
            return this.selector;
        }
        this.selector = new AndSelector();
        if (this.names != null && this.names.length > 0) {
            OrSelector namesSelector = new OrSelector();
            i = 0;
            while (i < this.names.length) {
                namesSelector.addSelector(new NameSelector(this.names[i], this.qualifier));
                ++i;
            }
            this.selector.addSelector(namesSelector);
        }
        if (this.identifiers != null && this.identifiers.length > 0) {
            ISelector identifiersSelector;
            if (this.qualifier.getComparisonStrategy() == 1) {
                identifiersSelector = new AndSelector();
                i = 0;
                while (i < this.identifiers.length) {
                    ((AndSelector)identifiersSelector).addSelector(new IdentifierSelector(this.identifiers[i]));
                    ++i;
                }
                this.selector.addSelector(identifiersSelector);
            } else {
                identifiersSelector = new OrSelector();
                i = 0;
                while (i < this.identifiers.length) {
                    ((OrSelector)identifiersSelector).addSelector(new IdentifierSelector(this.identifiers[i]));
                    ++i;
                }
                this.selector.addSelector(identifiersSelector);
            }
        }
        if (this.categories != null && this.categories.length > 0) {
            ISelector categoriesSelector;
            if (this.qualifier.getComparisonStrategy() == 3) {
                categoriesSelector = new OrSelector();
                i = 0;
                while (i < this.categories.length) {
                    if (this.qualifier.getCombineCategoryBags()) {
                        ((OrSelector)categoriesSelector).addSelector(new CombinedCategorySelector(this.categories[i]));
                    } else if (this.qualifier.getServiceSubset()) {
                        ((OrSelector)categoriesSelector).addSelector(new ServiceCategorySelector(this.categories[i]));
                    } else {
                        ((OrSelector)categoriesSelector).addSelector(new CategorySelector(this.categories[i]));
                    }
                    ++i;
                }
                this.selector.addSelector(categoriesSelector);
            } else {
                categoriesSelector = new AndSelector();
                i = 0;
                while (i < this.categories.length) {
                    if (this.qualifier.getCombineCategoryBags()) {
                        ((AndSelector)categoriesSelector).addSelector(new CombinedCategorySelector(this.categories[i]));
                    } else if (this.qualifier.getServiceSubset()) {
                        ((AndSelector)categoriesSelector).addSelector(new ServiceCategorySelector(this.categories[i]));
                    } else {
                        ((AndSelector)categoriesSelector).addSelector(new CategorySelector(this.categories[i]));
                    }
                    ++i;
                }
                this.selector.addSelector(categoriesSelector);
            }
        }
        if (this.tModelKeys != null && this.tModelKeys.length > 0) {
            ISelector tModelsSelector;
            if (this.qualifier.getComparisonStrategy() == 3) {
                tModelsSelector = new OrSelector();
                i = 0;
                while (i < this.tModelKeys.length) {
                    ((OrSelector)tModelsSelector).addSelector(new BusinessTModelSelector(this.tModelKeys[i]));
                    ++i;
                }
                this.selector.addSelector(tModelsSelector);
            } else {
                tModelsSelector = new AndSelector();
                i = 0;
                while (i < this.tModelKeys.length) {
                    ((AndSelector)tModelsSelector).addSelector(new BusinessTModelSelector(this.tModelKeys[i]));
                    ++i;
                }
                this.selector.addSelector(tModelsSelector);
            }
        }
        if (this.discoveryURLs != null && this.discoveryURLs.length > 0) {
            OrSelector discoveryURLsSelector = new OrSelector();
            i = 0;
            while (i < this.discoveryURLs.length) {
                discoveryURLsSelector.addSelector(new DiscoveryURLSelector(this.discoveryURLs[i]));
                ++i;
            }
            this.selector.addSelector(discoveryURLsSelector);
        }
        return this.selector;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("find_business");
        this.qualifier.write(query);
        if (this.names != null) {
            Name.writeList(query, this.names);
        }
        if (this.identifiers != null) {
            Identifier.writeList(query, this.identifiers);
        }
        if (this.categories != null) {
            Category.writeList(query, this.categories);
        }
        if (this.tModelKeys != null) {
            TModel.writeKeyList(query, this.tModelKeys);
        }
        if (this.discoveryURLs != null) {
            DiscoveryURL.writeList(query, this.discoveryURLs);
        }
    }

    public void read(IReader reader) throws IOException {
        this.qualifier = Qualifier.readQualifier(reader);
        if (reader.getReaders("name").length > 0) {
            this.names = Name.readList(reader);
            Name.validate(this.names);
        }
        IReader child = null;
        child = reader.getReader("identifierBag");
        if (child != null) {
            this.identifiers = Identifier.readList(child);
        }
        if ((child = reader.getReader("categoryBag")) != null) {
            this.categories = Category.readList(child);
        }
        if ((child = reader.getReader("tModelBag")) != null) {
            this.tModelKeys = TModel.readKeyList(child);
        }
        if ((child = reader.getReader("discoveryURLs")) != null) {
            this.discoveryURLs = DiscoveryURL.readList(child);
        }
    }
}

