/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.DeleteBindings;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class DeleteServices
implements IPublicationCommand {
    private String[] serviceKeys;

    public DeleteServices() {
    }

    public DeleteServices(String[] serviceKeys) {
        this.serviceKeys = serviceKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            int i = 0;
            while (i < this.serviceKeys.length) {
                DeleteServices.deleteService(server, this.serviceKeys[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return null;
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public static void deleteService(IUDDIServer server, String serviceKey, User user) throws UDDIException {
        if (!server.ownsService(serviceKey, user)) {
            throw new UDDIException(10140);
        }
        String[] bindingKeys = server.getBindingKeysForService(serviceKey);
        int i = 0;
        while (i < bindingKeys.length) {
            DeleteBindings.deleteBinding(server, bindingKeys[i], user);
            ++i;
        }
        server.eraseService(serviceKey);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("delete_service");
        UDDIUtil.writeStringList(query, "serviceKey", this.serviceKeys);
    }

    public void read(IReader reader) throws IOException {
        this.serviceKeys = UDDIUtil.getTexts(reader, "serviceKey");
    }
}

