/*
 * Decompiled with CFR 0.152.
 */
package electric.sql;

import electric.sql.ConnectionPool;
import electric.sql.ConnectionPoolManager;
import electric.sql.ISQLConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class SQLClient
implements ILoggingConstants,
ISQLConstants {
    private ConnectionPool pool;

    public SQLClient(String databaseName) {
        this(ConnectionPoolManager.getPool(databaseName));
    }

    public SQLClient(ConnectionPool pool) {
        this.pool = pool;
    }

    public SQLClient(String driverName, String url, String user, String password) throws Exception {
        this(driverName, url, user, password, 10);
    }

    public SQLClient(String driverName, String url, String user, String password, int maxSize) throws Exception {
        this(new ConnectionPool(driverName, url, user, password, maxSize));
    }

    public void insert(String statement) throws SQLException {
        this.execute(statement);
    }

    public void update(String statement) throws SQLException {
        this.execute(statement);
    }

    public void delete(String statement) throws SQLException {
        this.execute(statement);
    }

    public ResultSet select(String statement) throws SQLException {
        Connection connection = null;
        try {
            connection = this.pool.checkOutConnection();
            Statement stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery(statement);
            Object var6_6 = null;
            if (connection != null) {
                this.pool.checkInConnection(connection);
            }
            return resultSet;
        }
        catch (SQLException exception) {
            try {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "failure executing sql statement: " + statement, exception);
                }
                if (connection != null && connection.isClosed()) {
                    this.pool.connectionClosed();
                }
                throw exception;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_7 = null;
                    if (connection == null) break block7;
                    this.pool.checkInConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public void execute(String statement) throws SQLException {
        this.execute(new String[]{statement});
    }

    public void execute(String[] statements) throws SQLException {
        if (statements.length < 1) {
            return;
        }
        String sql = "";
        Connection connection = null;
        try {
            try {
                connection = this.pool.checkOutConnection();
                Statement statement = connection.createStatement();
                int i = 0;
                while (i < statements.length) {
                    sql = statements[i];
                    statement.execute(sql);
                    ++i;
                }
                connection.commit();
            }
            catch (SQLException exception) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "failure executing sql statement: " + sql, exception);
                }
                if (connection != null && connection.isClosed()) {
                    this.pool.connectionClosed();
                }
                connection.rollback();
                throw exception;
            }
            Object var7_7 = null;
            if (connection != null) {
                this.pool.checkInConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (connection != null) {
                this.pool.checkInConnection(connection);
            }
            throw throwable;
        }
    }
}

