/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.rpc.In;
import electric.soap.rpc.InOut;
import electric.soap.rpc.Out;
import electric.soap.rpc.Parameter;
import electric.soap.rpc.Return;
import electric.soap.util.SOAPEnvelopes;
import electric.soap.wsdl.ISOAPWriter;
import electric.soap.wsdl.SOAPOperation;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Part;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.encoded.EncodedReader;
import electric.xml.io.encoded.EncodedWriter;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;

public class RPCSOAPWriter
implements ISOAPWriter,
IWSDLConstants {
    protected static final String SMALL_PREFIX = "n";
    private SOAPOperation operation;
    private String requestName;
    private String responseName;
    private String encodingStyle;

    public RPCSOAPWriter(SOAPOperation operation) throws SchemaException {
        this(operation, null);
    }

    public RPCSOAPWriter(SOAPOperation operation, String encodingStyle) throws SchemaException {
        this.operation = operation;
        this.encodingStyle = encodingStyle;
        if (this.encodingStyle == null) {
            encodingStyle = operation.getBinding().getWSDL().getEncodingStyle();
        }
        this.setParameters();
    }

    public RPCSOAPWriter() {
    }

    public void setSOAPOperation(SOAPOperation operation) {
        this.operation = operation;
    }

    public IWriter getResponseWriter(SOAPMessage response) {
        if (response.getOptimizations().getEnvelopeOmission()) {
            Element reply = response.getDocument().newRoot();
            reply.setName(this.responseName);
            return new EncodedWriter(reply, this.operation.getNamespaces(), null, !response.getOptimizations().getTypeOmission(), this.encodingStyle);
        }
        Element body = response.getBody();
        Element reply = body.addElement();
        reply.setNamespace(SMALL_PREFIX, this.operation.getOutput().namespace);
        reply.setName(SMALL_PREFIX, this.responseName);
        Element root = response.getOptimizations().getHrefInlining() ? null : body;
        return new EncodedWriter(reply, this.operation.getNamespaces(), root, !response.getOptimizations().getTypeOmission(), this.encodingStyle);
    }

    public IWriter getRequestWriter(SOAPMessage request) {
        if (request.getOptimizations().getEnvelopeOmission()) {
            Element call = request.getDocument().newRoot();
            call.setName(this.requestName);
            return new EncodedWriter(call, this.operation.getNamespaces(), null, !request.getOptimizations().getTypeOmission(), this.encodingStyle);
        }
        Element body = request.getBody();
        Element call = body.addElement();
        String prefix = call.getPrefix(this.operation.getInput().namespace, SMALL_PREFIX);
        call.setName(prefix, this.requestName);
        Element root = request.getOptimizations().getHrefInlining() ? null : body;
        return new EncodedWriter(call, this.operation.getNamespaces(), root, !request.getOptimizations().getTypeOmission(), this.encodingStyle);
    }

    public IReader getReader(SOAPMessage response) {
        if (response.getOptimizations().getEnvelopeOmission()) {
            Element root = response.getRoot();
            return new EncodedReader(root, this.operation.getNamespaces(), root);
        }
        Element body = response.getBody();
        return new EncodedReader(body.getFirstElement(), this.operation.getNamespaces(), body);
    }

    public SOAPOptimizations selectOptimizations(SOAPOptimizations optimizations) {
        return this.operation.isAsync() ? SOAPOptimizations.DEFAULT : optimizations;
    }

    public boolean isRPC() {
        return true;
    }

    public void writeStyle(Element soapOperation) {
        soapOperation.setAttribute("style", "rpc");
    }

    public void setParameters() throws SchemaException {
        this.requestName = this.operation.getOperation().getName();
        this.responseName = this.requestName + "Response";
        if (this.operation.getOperation().getArgNames() != null) {
            this.setOrderedParameters();
        } else {
            this.setUnorderedParameters();
        }
    }

    private void setUnorderedParameters() throws SchemaException {
        this.operation.parameters = new Parameter[0];
        Part[] inputs = this.operation.getOperation().getInput().getMessage().getParts();
        boolean disableTypeOmission = this.operation.isPolymorphic();
        int i = 0;
        while (i < inputs.length) {
            SchemaElement element = new SchemaElement(inputs[i].getName(), inputs[i].getType(), false);
            element.setDisableTypeOmission(disableTypeOmission);
            this.operation.addParameter(new In(element, i + 1));
            ++i;
        }
        Part[] outputs = this.operation.getOperation().getOutput().getMessage().getParts();
        int i2 = 0;
        while (i2 < outputs.length) {
            if (!this.setInOut(outputs, i2)) {
                SchemaElement element = new SchemaElement(outputs[i2].getName(), outputs[i2].getType(), false);
                element.setDisableTypeOmission(disableTypeOmission);
                if (this.operation.getReturnValue() == null) {
                    this.operation.setReturnValue(new Return(element));
                } else {
                    this.operation.addParameter(new Out(element));
                }
            }
            ++i2;
        }
    }

    private boolean setInOut(Part[] outputs, int i) throws SchemaException {
        int j = 0;
        while (j < this.operation.parameters.length) {
            if (this.operation.parameters[j].getName().equals(outputs[i].getName())) {
                In in = (In)this.operation.parameters[j];
                this.operation.parameters[j] = new InOut(in.getSchemaElement(), in.requestIndex);
                return true;
            }
            ++j;
        }
        return false;
    }

    private void setOrderedParameters() throws SchemaException {
        Part[] parts = this.operation.getOperation().getOutput().getMessage().getParts();
        String[] argNames = this.operation.getOperation().getArgNames();
        this.operation.parameters = new Parameter[argNames.length];
        int requestIndex = 1;
        boolean disableTypeOmission = this.operation.isPolymorphic();
        if (parts.length > 0 && !this.operation.getOperation().hasParameterWithName(parts[0].getName())) {
            SchemaElement element = new SchemaElement(parts[0].getName(), parts[0].getType(), false);
            element.setDisableTypeOmission(disableTypeOmission);
            this.operation.setReturnValue(new Return(element));
        }
        int i = 0;
        while (i < argNames.length) {
            Part part = this.operation.getOperation().getPart(argNames[i]);
            if (part == null) {
                throw new SchemaException("unable to find parameter with name - " + argNames[i] + " on method " + this.requestName);
            }
            Part inputPart = this.operation.getOperation().getInput().getMessage().getPart(part.getName());
            Part outputPart = this.operation.getOperation().getOutput().getMessage().getPart(part.getName());
            SchemaElement schemaElement = new SchemaElement(part.getName(), part.getType(), false);
            schemaElement.setDisableTypeOmission(disableTypeOmission);
            this.operation.parameters[i] = inputPart == null ? new Out(schemaElement) : (outputPart == null ? new In(schemaElement, requestIndex++) : new InOut(schemaElement, requestIndex++));
            ++i;
        }
    }

    public void setDocument(SOAPMessage request, SOAPOptimizations optimizations) {
        if (optimizations.getEnvelopeOmission()) {
            request.setDocument(SOAPEnvelopes.newOptimizedEnvelope(), optimizations);
        } else {
            request.setDocument(SOAPEnvelopes.newEncodedEnvelope(this.operation.getVersion(), request.getSoapVersion()), optimizations);
        }
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public String getResponseName() {
        return this.responseName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }
}

