/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.rpc.In;
import electric.soap.rpc.InOut;
import electric.soap.rpc.Out;
import electric.soap.rpc.Parameter;
import electric.soap.rpc.Return;
import electric.soap.util.SOAPEnvelopes;
import electric.soap.wsdl.ISOAPWriter;
import electric.soap.wsdl.SOAPOperation;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Part;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.literal.LiteralWriter;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;

public class RPCLitSOAPWriter
implements ISOAPWriter,
IWSDLConstants {
    protected static final String SMALL_PREFIX = "n";
    private static boolean enabled;
    private static boolean allowEnable;
    private SOAPOperation operation;
    private String requestName;
    private String responseName;
    private String namespace;

    public RPCLitSOAPWriter(SOAPOperation operation) throws SchemaException {
        this.checkEnabled();
        this.operation = operation;
        this.setParameters();
    }

    public IReader getReader(SOAPMessage message) {
        return new LiteralReader(message.getBody().getFirstElement(), this.operation.getNamespaces());
    }

    public IWriter getResponseWriter(SOAPMessage response) {
        Element reply = response.getBody().addElement();
        this.setWrappedName(reply, this.responseName, this.operation.getOutput().namespace);
        return new LiteralWriter(reply, this.operation.getNamespaces(), !response.getOptimizations().getTypeOmission());
    }

    public IWriter getRequestWriter(SOAPMessage request) {
        Element call = request.getBody().addElement();
        this.setWrappedName(call, this.requestName, this.operation.getInput().namespace);
        return new LiteralWriter(call, this.operation.getNamespaces(), !request.getOptimizations().getTypeOmission());
    }

    private void setWrappedName(Element call, String messageName, String namespace) {
        call.setNamespace(SMALL_PREFIX, namespace);
        call.setName(SMALL_PREFIX, messageName);
    }

    public SOAPOptimizations selectOptimizations(SOAPOptimizations optimizations) {
        if (this.operation.isPolymorphic() || !optimizations.getTypeOmission()) {
            return SOAPOptimizations.NONE;
        }
        return SOAPOptimizations.DEFAULT;
    }

    public boolean isRPC() {
        return false;
    }

    public void writeStyle(Element soapOperation) {
        soapOperation.setAttribute("style", "rpc");
    }

    public void setDocument(SOAPMessage request, SOAPOptimizations optimizations) {
        request.setDocument(SOAPEnvelopes.newLiteralEnvelope(this.operation.getVersion()), optimizations);
    }

    public void setParameters() throws SchemaException {
        this.requestName = this.operation.getOperation().getName();
        this.responseName = this.requestName + "Response";
        if (this.operation.getOperation().getArgNames() != null) {
            this.setOrderedParameters();
        } else {
            this.setUnorderedParameters();
        }
    }

    private void setUnorderedParameters() throws SchemaException {
        this.operation.parameters = new Parameter[0];
        Part[] inputs = this.operation.getOperation().getInput().getMessage().getParts();
        boolean disableTypeOmission = this.operation.isPolymorphic();
        int i = 0;
        while (i < inputs.length) {
            SchemaElement element = new SchemaElement(inputs[i].getName(), inputs[i].getType(), false);
            element.setDisableTypeOmission(disableTypeOmission);
            this.operation.addParameter(new In(element, i + 1));
            ++i;
        }
        Part[] outputs = this.operation.getOperation().getOutput().getMessage().getParts();
        int i2 = 0;
        while (i2 < outputs.length) {
            if (!this.setInOut(outputs, i2)) {
                SchemaElement element = new SchemaElement(outputs[i2].getName(), outputs[i2].getType(), false);
                element.setDisableTypeOmission(disableTypeOmission);
                if (this.operation.getReturnValue() == null) {
                    this.operation.setReturnValue(new Return(element));
                } else {
                    this.operation.addParameter(new Out(element));
                }
            }
            ++i2;
        }
    }

    private boolean setInOut(Part[] outputs, int i) throws SchemaException {
        int j = 0;
        while (j < this.operation.parameters.length) {
            if (this.operation.parameters[j].getName().equals(outputs[i].getName())) {
                In in = (In)this.operation.parameters[j];
                this.operation.parameters[j] = new InOut(in.getSchemaElement(), in.requestIndex);
                return true;
            }
            ++j;
        }
        return false;
    }

    private void setOrderedParameters() throws SchemaException {
        boolean disableTypeOmission;
        Part[] parts = this.operation.getOperation().getOutput().getMessage().getParts();
        String[] argNames = this.operation.getOperation().getArgNames();
        this.operation.parameters = new Parameter[argNames.length];
        int requestIndex = 1;
        boolean bl = disableTypeOmission = this.operation.isPolymorphic() || !SOAPOptimizations.isTypeOmissionEnabled();
        if (parts.length > 0 && !this.operation.getOperation().hasParameterWithName(parts[0].getName())) {
            SchemaElement element = new SchemaElement(parts[0].getName(), parts[0].getType(), false);
            element.setDisableTypeOmission(disableTypeOmission);
            this.operation.setReturnValue(new Return(element));
        }
        int i = 0;
        while (i < argNames.length) {
            Part part = this.operation.getOperation().getPart(argNames[i]);
            if (part == null) {
                throw new SchemaException("unable to find parameter with name - " + argNames[i] + " on method " + this.requestName);
            }
            Part inputPart = this.operation.getOperation().getInput().getMessage().getPart(part.getName());
            Part outputPart = this.operation.getOperation().getOutput().getMessage().getPart(part.getName());
            SchemaElement schemaElement = new SchemaElement(part.getName(), part.getType(), false);
            schemaElement.setDisableTypeOmission(disableTypeOmission);
            this.operation.parameters[i] = inputPart == null ? new Out(schemaElement) : (outputPart == null ? new In(schemaElement, requestIndex++) : new InOut(schemaElement, requestIndex++));
            ++i;
        }
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public String getResponseName() {
        return this.responseName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("RPC literal support cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"RPC literal support could not be enabled");
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("RPC literal support is disabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"RPC literal support is disabled");
    }

    static {
        allowEnable = true;
    }
}

